package com.ifourthwall.dbm.sentry.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.CheckAccessUtils;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.MetricValueRecordListDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.*;
import com.ifourthwall.dbm.asset.facade.DashboardFacade;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdBO;
import com.ifourthwall.dbm.sentry.bo.QueryAppIdQueryDoBO;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardDoBO;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardQuDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListBO;
import com.ifourthwall.dbm.sentry.bo.metric.MetricValueRecordListReqBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.domain.DashboardRepository;
import com.ifourthwall.dbm.sentry.domain.GodzillaServerRepository;
import com.ifourthwall.dbm.sentry.domain.MonitorRepository;
import com.ifourthwall.dbm.sentry.service.DashboardDataService;
import com.ifourthwall.dbm.sentry.service.DashboardService;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/6/29 15:43
 * @Description:
 */
@Slf4j
@Service("DashboardDataServiceImpl")
public class DashboardDataServiceImpl implements DashboardDataService {

    @Reference(version = "1.0.0")
    private DashboardFacade dashboardFacade;

    @Autowired
    private DashboardRepository dashboardRepository;

    @Resource(name = "MonitorRepository")
    private MonitorRepository monitorRepository;


    @Autowired
    private GodzillaServerRepository godzillaServerRepository;

    /**
     * Sentry仪表盘数据查询
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.dashboard.InsertDashboardDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/2 10:15
     */
    @Override
    public BaseResponse<DashboardQueryDataDTO> queryData(DashboardQueryDataQuDTO query, IFWUser user) {
        BaseResponse<DashboardQueryDataDTO> response = new BaseResponse<>();
        try {
            DashboardQueryDataDTO result = new DashboardQueryDataDTO();
            String tenantId = CheckAccessUtils.judgeTenantId(query.getTenantId(), user);
            query.setTenantId(tenantId);
            //查询appId
            QueryAppIdQueryDoBO queryAppId = new QueryAppIdQueryDoBO();
            queryAppId.setTenantId(tenantId);
            QueryAppIdBO queryAppIdBO = monitorRepository.queryAppId(queryAppId);
            if (queryAppIdBO == null) {
                throw new BizException(PlatformCodeEnum.APP_NOT_FIND.getDesc(), PlatformCodeEnum.APP_NOT_FIND.getCode());
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            //查询时间
            Date startTime = null;
            Date endTime = null;
            if ("1".equals(query.getTime())) {
                startTime = DataUtils.getDayBegin();
                endTime = DataUtils.getDayEnd();
            }
            ArrayList<DashboardMetricListDTO> dataList = new ArrayList<>();
            for (String dataPointId : query.getDataPointId()) {
                //查询数据点位信息
                MetricValueRecordListReqBO querygodzilla = new MetricValueRecordListReqBO();
                querygodzilla.setEndTime(endTime);
                querygodzilla.setStartTime(startTime);
                querygodzilla.setDataPointId(dataPointId);
                querygodzilla.setAppId(queryAppIdBO.getAppId());
                MetricValueRecordListBO queryInfo = godzillaServerRepository.queryMetricValueRecordList(querygodzilla);
                if (queryInfo == null) {
                    continue;
                }
                DashboardMetricListDTO dateInfo = IFWBeanCopyUtil.map(queryInfo, DashboardMetricListDTO.class);

                //查询点位名称
                queryDataPointIdQuBO queryDataPointIdQuBO = new queryDataPointIdQuBO();
                queryDataPointIdQuBO.setDataPointId(dataPointId);
                queryDataPointIdBO queryDataPointIdBO = monitorRepository.queryDataPointId(queryDataPointIdQuBO);
                dateInfo.setDataPointId(queryDataPointIdBO.getDataPointId());
                dateInfo.setDataPointName(queryDataPointIdBO.getMonitorMetricName());
                dataList.add(dateInfo);
            }
            if ("2".equals(query.getType())){
                //折线图
                result.setDataPointId(dataList);
            }
            if ("1".equals(query.getType())){
                if ("1".equals(query.getSumType())){


                }else if ("2".equals(query.getSumType())){


                }

            }
            response.setData(result);
            response.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            response.setRetCode(bizException.getCode());
            response.setRetMsg(bizException.getMessage());
            response.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            response.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            response.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            response.setFlag(false);
        }
        return response;
    }

    public static void main(String[] args) {

    }

}
