package com.ifourthwall.dbm.sentry.service;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.TrackerMeterReadingQuDTO;
import com.ifourthwall.dbm.asset.dto.godzilla.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/8/25 11:19
 * @Description:
 */
public interface MonitorGodzillaService {
    /**
     * 新增触发规则
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     * @param add
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse addMaxAndMin(AddMaxAndMinDTO add, IFWUser user);

    /**
     * 修改触发规则
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     * @param update
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateMaxAndMin(UpdateMaxAndMinDTO update, IFWUser user);

    /**
     * 删除触发规则
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteMaxAndMin(DeleteMaxAndMinDTO delete, IFWUser user);

    /**
     * 查询触发规则
     * @Author: YangPeng
     * @Date: 2020/8/25 11:23
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.godzilla.QueryMaxAndMinDTO>>
     * @throws
     */
    BaseResponse<List<QueryMaxAndMinDTO>> queryMaxAndMin(QueryMaxAndMinQuDTO query, IFWUser user);
}
