package com.ifourthwall.dbm.sentry.service;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.dashboard.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/6/29 15:43
 * @Description:
 */
public interface DashboardService {

    /**
     * 新增仪表盘
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     * @param inseret
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertDashboard(InsertDashboardDTO inseret, IFWUser user);

    /**
     * 修改仪表盘
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     * @param update
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateDashboard(UpdateDashboardDTO update, IFWUser user);

    /**
     * 删除仪表盘
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteDashboard(DeleteDashboardDTO delete, IFWUser user);

    /**
     * 查询仪表盘
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardDTO>>
     * @throws
     */
    BaseResponse<QueryDashboardDTO> queryDashboard(QueryDashboardQuDTO query, IFWUser user);

    /**
     * 新增模块
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     * @param inseret
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertPanel(InsertDashboardPanelDTO inseret, IFWUser user);

    /**
     * 修改模块
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     * @param update
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updatePanel(UpdatePanelDTO update, IFWUser user);

    /**
     * 删除模块
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     * @param delete
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deletePanel(DeletePanelDTO delete, IFWUser user);

    /**
     * 新增仪表盘-非自定义
     * @Author: YangPeng
     * @Date: 2020/7/20 16:34
     * @param inseret
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse noCustomInsert(InsertDashboardAndPanelDTO inseret, IFWUser user);

    /**
     * 查询仪表盘（不包括panel）
     * @Author: YangPeng
     * @Date: 2020/7/21 15:27
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.dashboard.DashboardPanelDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<DashboardPanelDTO>> queryDashboardPanel(QueryDashboardPanelQuDTO query, IFWUser user);
}
