package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.project.dto.space.QuerySpaceListByNameDTO;
import com.ifourthwall.dbm.project.dto.space.QuerySpaceListByNameQuDTO;
import com.ifourthwall.dbm.project.facade.ProjectSpaceTwoFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.project.dto.*;
import com.ifourthwall.dbm.project.facade.ProjectSpaceFacade;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/4 14:02
 * @Description:
 */
@Slf4j
@Repository("SpaceRepository")
public class SpaceRepository {


    @Reference(version = "1.0.0")
    private ProjectSpaceFacade projectSpaceFacade;

    @Reference(version = "1.0.0")
    private ProjectSpaceTwoFacade projectSpaceTwoFacade;

    /**
     * 获取子空间
     *
     * @param sonSpace
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.GetSonSpaceBO
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/4 16:01
     */
    public GetSonSpaceBO getSonpace(GetSonSpaceQueryBO sonSpace) {
        GetSonSpaceBO result = new GetSonSpaceBO();
        log.info("接口 getSonpace ,接受参数:{}", sonSpace);
        BaseResponse<GetSonSpaceDTO> sonpace = projectSpaceFacade.getSonpace(IFWBeanCopyUtil.map(sonSpace, GetSonSpaceQueryDTO.class));
        log.info("接口 getSonpace ,返回结果:{}", sonpace);
        if (!sonpace.isFlag()) {
            throw new BizException(sonpace.getRetMsg(), sonpace.getRetCode());
        }
        if (sonpace.getData() != null) {
            return IFWBeanCopyUtil.map(sonpace.getData(),GetSonSpaceBO.class);
        }
        return result;
    }

    /**
     * 根据项目id获取空间
     *
     * @param spaceIds
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.GetSonSpaceBO
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/4 16:03
     */
    public GetSonSpaceBO querySpaceIds(QuerySpaceIdsQueryBO spaceIds) {
        GetSonSpaceBO result = new GetSonSpaceBO();
        QuerySpaceIdsDTO query = new QuerySpaceIdsDTO();
        query.setProjectId(spaceIds.getProjectId());
        log.info("接口 querySpaceIds ,接受参数:{}", spaceIds);
        BaseResponse<List<ProjectSpaceBaseDTO>> response = projectSpaceFacade.querySpaceIds(query);
        log.info("接口 querySpaceIds ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())) {
            ArrayList<String> strings = new ArrayList<>();
            for (ProjectSpaceBaseDTO datum : response.getData()) {
                strings.add(datum.getProjectSpaceId());
            }
            result.setSpaceId(strings);
            return result;
        }
        return result;
    }


    public List<ProjectSpacePathBO> getNewPathBatch(GetNewPathBatchQueryBO newPathBatchQuery) {
        log.info("接口 getNewPathBatch ,接受参数:{}", newPathBatchQuery);
        BaseResponse<List<ProjectSpacePathDTO>> newPathBatch = projectSpaceFacade.getNewPathBatch(IFWBeanCopyUtil.map(newPathBatchQuery, GetNewPathBatchQueryDTO.class));
        log.info("接口 getNewPathBatch ,返回结果:{}", newPathBatchQuery);
        if (!newPathBatch.isFlag()) {
            throw new BizException(newPathBatch.getRetMsg(), newPathBatch.getRetCode());
        }
        if (DataUtils.isListAvali(newPathBatch.getData())) {
            List<ProjectSpacePathBO> projectSpacePathBOS = IFWBeanCopyUtil.mapAsList(newPathBatch.getData(), ProjectSpacePathBO.class);
            return projectSpacePathBOS;
        }
        return new ArrayList<>();
    }

    /**
     * 查询空间详情
     * @Author: YangPeng
     * @Date: 2020/4/24 21:52
     * @param newPathBatchQuery
     * @return com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO
     * @throws
     */
    public ProjectSpaceBaseDoBO querySpaceInfo(QuerySpaceInfoQueryDoBO newPathBatchQuery) {
        log.info("接口 querySpaceInfo ,接受参数:{}", newPathBatchQuery);
        BaseResponse<ProjectSpaceBaseDTO> response = projectSpaceFacade.querySpaceInfo(IFWBeanCopyUtil.map(newPathBatchQuery, QuerySpaceInfoQueryDTO.class));
        log.info("接口 querySpaceInfo ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return IFWBeanCopyUtil.map(response.getData(), ProjectSpaceBaseDoBO.class);
        }
        return null;
    }


    /**
     * 查询空间详情
     * @Author: YangPeng
     * @Date: 2020/4/24 21:52
     * @param newPathBatchQuery
     * @return com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO
     * @throws
     */
    public QueryNextSonListDoBO queryNextSonList(QueryNextSonListQuDoBO newPathBatchQuery) {
        log.info("接口 querySpaceInfo ,接受参数:{}", newPathBatchQuery);
        BaseResponse<QueryNextSonListDTO> response = projectSpaceFacade.queryNextSonList(IFWBeanCopyUtil.map(newPathBatchQuery, QueryNextSonListQuDTO.class));
        log.info("接口 querySpaceInfo ,返回结果:{}", newPathBatchQuery);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return IFWBeanCopyUtil.map(response.getData(), QueryNextSonListDoBO.class);
        }
        return null;
    }

    /**
     * 查询空间列表（list）
     * @Author: YangPeng
     * @Date: 2020/4/30 16:05
     * @param newPathBatchQuery
     * @return java.util.List<com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO>
     * @throws
     */
    public List<ProjectSpaceBaseDoBO> getSonSpaceList(ProjectSpaceSubListQueryDoBO newPathBatchQuery) {
        log.info("接口 querySpaceInfo ,接受参数:{}", newPathBatchQuery);
        BaseResponse<List<ProjectSpaceBaseDTO>> response = projectSpaceFacade.getSonSpaceList(IFWBeanCopyUtil.map(newPathBatchQuery, ProjectSpaceSubListQueryDTO.class));
        log.info("接口 querySpaceInfo ,返回结果:{}", newPathBatchQuery);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return IFWBeanCopyUtil.mapAsList(response.getData(), ProjectSpaceBaseDoBO.class);
        }
        return null;
    }

    /**
     * 查询空间列表（list）
     * @Author: YangPeng
     * @Date: 2020/4/30 16:05
     * @param newPathBatchQuery
     * @return java.util.List<com.ifourthwall.dbm.sentry.bo.ProjectSpaceBaseDoBO>
     * @throws
     */
    public List<QuerySpaceListByNameDTO> querySpaceListByName(QuerySpaceListByNameQuDTO query) {
        log.info("接口 querySpaceListByName ,接受参数:{}", query);
        BaseResponse<List<QuerySpaceListByNameDTO>> response = projectSpaceTwoFacade.querySpaceListByName(query);
        log.info("接口 querySpaceListByName ,返回结果:{}", query);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return response.getData();
        }
        return null;
    }


}
