package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.asset.facade.MonitorTargetTagFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/4 10:37
 * @Description:
 */
@Slf4j
@Repository("MonitorTargetTagRepository")
public class MonitorTargetTagRepository {


    @Reference(version = "1.0.0")
    private MonitorTargetTagFacade targetTagFacade;

    /**
     * 根据标签查询
     * @Author: YangPeng
     * @Date: 2020/4/28 21:01
     * @param query
     * @return com.ifourthwall.dbm.sentry.bo.QueryTagInfoListBO
     * @throws
     */
    public List<QueryTagInfoListDTO> queryTagInfoList(QueryTagInfoListQuBO query) {
        ArrayList<QueryTagInfoListDTO> resultList = new ArrayList<>();
        QueryTagInfoListBO result = new QueryTagInfoListBO();
        log.info("接口 queryTagInfoList ,接受参数:{}", query);
        BaseResponse<List<QueryTagInfoListDTO>> response = targetTagFacade.queryTagInfoList(IFWBeanCopyUtil.map(query,QueryTagInfoListQuDTO.class));
        log.info("接口 queryTagInfoList ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())){
            return IFWBeanCopyUtil.mapAsList(response.getData(),QueryTagInfoListDTO.class);
        }
        return resultList;

    }
}
