package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.app.UpdateAppIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryInsertAlertIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.*;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.asset.facade.MonitorTwoFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.metric.QueryEnvironmentListDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.QueryMonitorMetricListDoBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO;
import com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdQuBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/4 10:37
 * @Description:
 */
@Slf4j
@Repository("MonitorRepository")
public class MonitorRepository {


    @Reference(version = "1.0.0")
    private MonitorFacade monitorFacade;

    @Reference(version = "1.0.0")
    private MonitorTwoFacade monitorTwoFacade;

    /**
     * 查询资产信息
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     * @param monitorInfo
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     */
    public QueryMonitorInfoDoBO queryMonitorInfo(QueryMonitorInfoQueryBasisDoBO monitorInfo){
        //组装请求参数
        QueryMonitorInfoDoBO result = new QueryMonitorInfoDoBO();
        QueryMonitorInfoQueryDTO queryMonitorInfo = new QueryMonitorInfoQueryDTO();
        BeanUtils.copyProperties(monitorInfo,queryMonitorInfo);
        queryMonitorInfo.setLanguageCode(monitorInfo.getLanguageCode());
        log.info("接口 queryMonitorInfo ,接受参数:{}", monitorInfo);
        BaseResponse<QueryMonitorInfoDTO> response = monitorFacade.queryMonitorInfo(queryMonitorInfo);
        log.info("接口 queryMonitorInfo ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() == null){
            return null;
        }
        BeanUtils.copyProperties(response.getData(),result);
        return result;
    }


    /**
     * 查询监控列表
     * @Author: YangPeng
     * @Date: 2019/12/16 18:21
     * @param monitorList
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryMonitorInfoDoBO
     * @throws
     */
    public IFWPageInfo<QueryMonitorListDoBO> queryMonitorList(QueryMonitorListDoQueryBO monitorList){
        IFWPageInfo<QueryMonitorListDoBO> resultPage = new IFWPageInfo<>();
        //组装请求参数
        QueryMonitorListDoQueryDTO querylist = new QueryMonitorListDoQueryDTO();
        BeanUtils.copyProperties(monitorList,querylist);
        log.info("接口 queryMonitorInfo ,接受参数:{}", monitorList);
        BaseResponse<IFWPageInfo<QueryMonitorListDTO>> response = monitorFacade.queryMonitorList(querylist);
        log.info("接口 queryMonitorInfo ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (!DataUtils.isListAvali(response.getData().getList())){
            return null;
        }
        BeanUtils.copyProperties(response.getData(),resultPage,"list");
        List<QueryMonitorListDoBO> resultList = IFWBeanCopyUtil.mapAsList(response.getData().getList(), QueryMonitorListDoBO.class);
        resultPage.setList(resultList);
        return resultPage;
    }


    /**
     * 查询监控记录列表
     * @Author: YangPeng
     * @Date: 2019/12/19 10:14
     * @param recording
     * @return com.ifourthwall.dbm.sentry.dto.PageDTO<com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryRecordingListDoBO>
     * @throws
     */
    public PageDTO<QueryRecordingListDoBO> queryRecordingList(QueryRecordingQueryDoBO recording){
        PageDTO<QueryRecordingListDoBO> resultPage = new PageDTO<>();
        //组装请求参数
        QueryRecordingQueryDTO querylist = new QueryRecordingQueryDTO();
        BeanUtils.copyProperties(recording,querylist);
        log.info("接口 queryMonitorList ,接受参数:{}", recording);
        BaseResponse<IFWPageInfo<QueryRecordingListDTO>> response = monitorFacade.queryRecordingList(querylist);
        log.info("接口 queryMonitorList ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (!DataUtils.isListAvali(response.getData().getList())){
            return resultPage;
        }
        BeanUtils.copyProperties(response.getData(),resultPage,"list");
        List<QueryRecordingListDoBO> resultList = IFWBeanCopyUtil.mapAsList(response.getData().getList(), QueryRecordingListDoBO.class);
        resultPage.setResult(resultList);
        return resultPage;
    }


    /**
     * 查询tenantId
     * @Author: YangPeng
     * @Date: 2019/12/19 10:14
     * @param recording
     * @return com.ifourthwall.dbm.sentry.dto.PageDTO<com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryRecordingListDoBO>
     * @throws
     */
    public QueryTenantIdBO queryTenantId(QueryTenantIdDoQueryBO recording){
        QueryTenantIdBO result = new QueryTenantIdBO();
        //组装请求参数
        QueryTenantIdDoQueryDTO querylist = new QueryTenantIdDoQueryDTO();
        BeanUtils.copyProperties(recording,querylist);
        log.info("接口 queryTenantId ,接受参数:{}", recording);
        BaseResponse<QueryTenantIdDTO> response = monitorFacade.queryTenantId(querylist);
        log.info("接口 queryTenantId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() == null){
            return result;
        }
        BeanUtils.copyProperties(response.getData(),result);
        return result;
    }

    /**
     * 接收哥斯拉信息(插入)
     * @Author: YangPeng
     * @Date: 2019/12/20 15:10
     * @param dataPoint
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryTenantIdBO
     * @throws
     */
    public void insetMonitorRecord(GetDataPointQueryDoBO dataPoint){
        //组装请求参数
        GetDataPointQueryDTO querylist = new GetDataPointQueryDTO();
        BeanUtils.copyProperties(dataPoint,querylist);
        log.info("接口 insetMonitorRecord ,接受参数:{}", dataPoint);
        BaseResponse response = monitorFacade.insetMonitorRecord(querylist);
        log.info("接口 insetMonitorRecord ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }

    /**
     * 接收哥斯拉信息（更新）
     * @Author: YangPeng
     * @Date: 2019/12/20 15:10
     * @param
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryTenantIdBO
     * @throws
     */
    public void  upMonitorRecord(UpMonitorRecordDoBO monitorRecord){
        //组装请求参数
        UpMonitorRecordDTO upMonitorRecord = new UpMonitorRecordDTO();
        BeanUtils.copyProperties(monitorRecord,upMonitorRecord);
        log.info("接口 queryTenantId ,接受参数:{}", monitorRecord);
        BaseResponse response = monitorFacade.upMonitorRecord(upMonitorRecord);
        log.info("接口 queryTenantId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }

    public void  upMonitorByTaskId(UpMonitorRecordDoBO monitorRecord){
        //组装请求参数
        UpMonitorRecordDTO upMonitorRecord = new UpMonitorRecordDTO();
        BeanUtils.copyProperties(monitorRecord,upMonitorRecord);
        log.info("接口 queryTenantId ,接受参数:{}", monitorRecord);
        BaseResponse response = monitorFacade.upMonitorByTaskId(upMonitorRecord);
        log.info("接口 queryTenantId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }

    public Boolean queryTaskId(QueryTaskIdQuDoBO id){
        //组装请求参数
        QueryTaskIdQuDTO querylist = new QueryTaskIdQuDTO();
        BeanUtils.copyProperties(id,querylist);
        log.info("接口 queryMonitorList ,接受参数:{}", id);
        BaseResponse<Boolean> response = monitorFacade.queryTaskId(querylist);
        log.info("接口 queryMonitorList ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }

        return response.getData();
    }
    /**
     * 新增/修改监控（不包括指标）
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     * @param
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     */
    public void upInsertMonitor(UpInsertMonitorDoBO upinsertMonitor){
        log.info("接口 upInsertMonitor ,接受参数:{}", upinsertMonitor);
        BaseResponse response = monitorFacade.upInsertMonitor(IFWBeanCopyUtil.map(upinsertMonitor, UpInsertMonitorDTO.class));
        log.info("接口 upInsertMonitor ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }


    /**
     * 根据datapointId查询
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     * @param
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     */
    public QueryDataByMonitorDoBO queryDataByMonitor(QueryDataByMonitorQuDoBO queryDataPoint){
        //组装请求参数
        QueryDataByMonitorDoBO result = new QueryDataByMonitorDoBO();
        QueryDataByMonitorQuDTO query = new QueryDataByMonitorQuDTO();
        BeanUtils.copyProperties(queryDataPoint,query);
        log.info("接口 queryDataByMonitor ,接受参数:{}", query);
        BaseResponse<QueryDataByMonitorDTO> response = monitorFacade.queryDataByMonitor(query);
        log.info("接口 queryDataByMonitor ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        BeanUtils.copyProperties(response.getData(),result);
        return result;
    }

    /**
     * 存入appId
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     * @param
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     */
    public void insertAppId(InsertAppIdQuDoBO insertAppId){
        //组装请求参数
        QueryDataByMonitorDoBO result = new QueryDataByMonitorDoBO();
        InsertAppIdQuDTO insert = new InsertAppIdQuDTO();
        BeanUtils.copyProperties(insertAppId,insert);
        log.info("接口 insertAppId ,接受参数:{}", insert);
        BaseResponse response = monitorFacade.insertAppId(insert);
        log.info("接口 insertAppId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }

    /**
     * 查询appid
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     * @param
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     */
    public QueryAppIdBO queryAppId(QueryAppIdQueryDoBO queryAppId){
        //组装请求参数
        QueryAppIdBO result = new QueryAppIdBO();
        QueryAppIdQueryDTO query = new QueryAppIdQueryDTO();
        BeanUtils.copyProperties(queryAppId,query);
        log.info("接口 queryAppId ,接受参数:{}", query);
        BaseResponse<QueryAppIdDTO> response = monitorFacade.queryAppId(query);
        log.info("接口 queryAppId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() == null){
            return result;
        }
        BeanUtils.copyProperties(response.getData(),result);
        return result;

    }

    /**
     * 更新appId
     * @Author: YangPeng
     * @Date: 2020/11/17 19:12
     * @param update
     * @return void
     * @throws
     */
    public void updateAppId(UpdateAppIdQuDTO update){
        log.info("接口 updateAppId ,接受参数:{}", update);
        BaseResponse response = monitorFacade.updateAppId(update);
        log.info("接口 updateAppId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
    }

    /**
     * 通过datePointId查询assetId
     * @Author: YangPeng
     * @Date: 2020/1/13 14:31
     * @param queryAppId
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryAssetByDPDoBO
     * @throws
     */
    public QueryAssetByDPDoBO queryAssetByDP(QueryAssetByDPDoQuBO queryAppId){
        //组装请求参数
        QueryAssetByDPDoBO result = new QueryAssetByDPDoBO();
        log.info("接口 queryAssetByDP ,接受参数:{}", queryAppId);
        BaseResponse<QueryAssetByDPDTO> response = monitorFacade.queryAssetByDP(IFWBeanCopyUtil.map(queryAppId,QueryAssetByDPQuDTO.class));
        log.info("接口 queryAssetByDP ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() == null){
            log.error("此datePointId查询不到相关资产无法更改状态：datePointId:{}"+ queryAppId.getDataPointId());
            throw new BizException("无此checkPoint，请查看配置","15");
        }
        BeanUtils.copyProperties(response.getData(),result);
        return result;

    }

    /**
     * 查询AlertId是否存在
     * @Author: YangPeng
     * @Date: 2020/4/20 9:55
     * @param queryAlertId
     * @return java.lang.Boolean
     * @throws
     */
    public Boolean queryAlertId(QueryAlertIdDoBO queryAlertId) {
        //组装请求参数
        QueryAssetByDPDoBO result = new QueryAssetByDPDoBO();
        log.info("接口 queryAlertId ,接受参数:{}", queryAlertId);
        BaseResponse<Boolean> response = monitorFacade.queryAlertId(IFWBeanCopyUtil.map(queryAlertId,QueryAlertIdDTO.class));
        log.info("接口 queryAlertId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        return response.getData();
    }

    /**
     * 通过dataPointId查询监控指标名字
     * @Author: YangPeng
     * @Date: 2020/7/2 16:43
     * @param queryAlertId
     * @return com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO
     * @throws
     */
    public queryDataPointIdBO queryDataPointId(queryDataPointIdQuBO queryAlertId) {
        //组装请求参数
        queryDataPointIdBO result = new queryDataPointIdBO();
        log.info("接口 queryDataPointId ,接受参数:{}", queryAlertId);
        BaseResponse<queryDataPointIdDTO> response = monitorFacade.queryDataPointId(IFWBeanCopyUtil.map(queryAlertId, queryDataPointIdQuDTO.class));
        log.info("接口 queryDataPointId ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() != null){
            return IFWBeanCopyUtil.map(response.getData(),queryDataPointIdBO.class);
        }
        return null;
    }

    /**
     * 查询监控指标详细
     * @Author: YangPeng
     * @Date: 2020/7/2 16:43
     * @param queryAlertId
     * @return com.ifourthwall.dbm.sentry.bo.metric.queryDataPointIdBO
     * @throws
     */
    public List<QueryEnvironmentListDoBO> queryMonitorMetricList(QueryMonitorMetricListDoBO queryAlertId) {
        //组装请求参数
        queryDataPointIdBO result = new queryDataPointIdBO();
        log.info("接口 queryMonitorMetricList ,接受参数:{}", queryAlertId);
        BaseResponse<List<QueryEnvironmentListDTO>> response = monitorFacade.queryMonitorMetricList(IFWBeanCopyUtil.map(queryAlertId, QueryEnvironmentListQuDTO.class));
        log.info("接口 queryMonitorMetricList ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() != null){
            return IFWBeanCopyUtil.mapAsList(response.getData(),QueryEnvironmentListDoBO.class);
        }
        return null;
    }


    /**
     * 查询监控记录列表（日周月）
     * @Author: YangPeng
     * @Date: 2019/12/19 10:14
     * @param query
     * @return com.ifourthwall.dbm.sentry.dto.PageDTO<com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryRecordingListDoBO>
     * @throws
     */
    public List<QueryRecordingListByTimeDTO> queryRecordingListByTime(QueryRecordingListByTimeQuDTO query){
        log.info("接口 queryRecordingListByTime ,接受参数:{}", query);
        BaseResponse<List<QueryRecordingListByTimeDTO>> response = monitorTwoFacade.queryRecordingListByTime(query);
        log.info("接口 queryRecordingListByTime ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())){
            return response.getData();
        }
        return null;
    }


    /**
     * 查询设备返修率
     * @Author: YangPeng
     * @Date: 2019/12/19 10:14
     * @param query
     * @return com.ifourthwall.dbm.sentry.dto.PageDTO<com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryRecordingListDoBO>
     * @throws
     */
    public List<QueryRecordingRepairDTO> queryRecordingRepair(QueryRecordingRepairQuDTO query){
        log.info("接口 queryRecordingRepair ,接受参数:{}", query);
        BaseResponse<List<QueryRecordingRepairDTO>> response = monitorTwoFacade.queryRecordingRepair(query);
        log.info("接口 queryRecordingRepair ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (DataUtils.isListAvali(response.getData())){
            return response.getData();
        }
        return null;
    }


    /**
     * 查沟通过系统询监控记录列表
     * @Author: YangPeng
     * @Date: 2019/12/19 10:14
     * @param query
     * @return com.ifourthwall.dbm.sentry.dto.PageDTO<com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.QueryRecordingListDoBO>
     * @throws
     */
    public QueryRecordingListBySystemDTO queryRecordingListBySystem(QueryRecordingListBySystemQuDTO query){
        log.info("接口 queryRecordingListBySystem ,接受参数:{}", query);
        BaseResponse<QueryRecordingListBySystemDTO> response = monitorTwoFacade.queryRecordingListBySystem(query);
        log.info("接口 queryRecordingListBySystem ,返回结果:{}", response);
        if(!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() != null){
            return response.getData();
        }
        return null;
    }
}
