package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardDTO;
import com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetFacade;
import com.ifourthwall.dbm.asset.facade.DashboardFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardDoBO;
import com.ifourthwall.dbm.sentry.bo.dashboard.QueryDashboardQuDoBO;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/12/4 10:37
 * @Description:
 */
@Slf4j
@Repository("DashboardRepository")
public class DashboardRepository {


    @Reference(version = "1.0.0")
    private DashboardFacade dashboardFacade;


    /**
     * 查询仪表盘相关组件
     *
     * @param assetInfo
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.AssetBO
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/5 9:47
     */
    public QueryDashboardDoBO queryDashboard(QueryDashboardQuDoBO assetInfo) {
        QueryAssetInfoDoBO resultBO = new QueryAssetInfoDoBO();
        //组装请求参数
        QueryAssetInfoQueryDTO queryAsset = new QueryAssetInfoQueryDTO();
        BeanUtils.copyProperties(assetInfo, queryAsset);
        log.info("接口 queryDashboard ,接受参数:{}", assetInfo);
        BaseResponse<QueryDashboardDTO> response = dashboardFacade.queryDashboard(IFWBeanCopyUtil.map(assetInfo, QueryDashboardQuDTO.class));
        log.info("接口 queryDashboard ,返回结果:{}", response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        if (response.getData() != null) {
            return IFWBeanCopyUtil.map(response.getData(),QueryDashboardDoBO.class);
        }
        return null;
    }


}
