package com.ifourthwall.dbm.sentry.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.facade.CheckpoinAssetFacade;
import com.ifourthwall.dbm.sentry.bo.*;
import com.ifourthwall.dbm.sentry.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

/**
 * @Author: YangPeng
 * @Date: 2019/12/5 11:41
 * @Description:
 */
@Slf4j
@Service("CheckpoinAssetRepository")
public class CheckpoinAssetRepository  {

    @Reference(version = "1.0.0")
    private CheckpoinAssetFacade checkpoinAssetFacade;

    /**
     * 查询点位详情
     *
     * @param checkPointInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.sentry.dto.CheckPointInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/12/5 18:18
     */
    public CheckPointInfoDoBO checkPointInfo(CheckPointInfoDoQueryBO checkPointInfo) {
        CheckPointInfoDoBO resultDTO = new CheckPointInfoDoBO();
        log.info("接口 checkPointInfo ,接受参数:{}", checkPointInfo);
        BaseResponse<CheckPointInfoDTO> response = checkpoinAssetFacade.checkPointInfo(IFWBeanCopyUtil.map(checkPointInfo, CheckPointInfoQueryDTO.class));
        log.info("接口 checkPointInfo ,返回结果:{}", response);
        if (!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() != null){
            BeanUtils.copyProperties(response.getData(),resultDTO);
        }
        return resultDTO;
    }

    /**
     * 删除点位
     * @Author: YangPeng
     * @Date: 2019/12/9 14:18
     * @param deleteCheckPoint
     * @return void
     * @throws
     */
    public void deleteCheckPoint(DeleteCheckPointDoQueryBO deleteCheckPoint){
        log.info("接口 deleteCheckPoint ,接受参数:{}", deleteCheckPoint);
        BaseResponse<CheckPointInfoDTO> response = checkpoinAssetFacade.deleteCheckPoint(IFWBeanCopyUtil.map(deleteCheckPoint, DeleteCheckPointQueryDTO.class));
        log.info("接口 deleteCheckPoint ,返回结果:{}", response);
        if (!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }

    }

    /**
     * 查询点位列表
     * @Author: YangPeng
     * @Date: 2019/12/9 14:19
     * @param checkPointList
     * @return com.ifourthwall.dbm.sentry.com.ifourthwall.dbm.seer.bo.CheckPointInfoDoBO
     * @throws
     */
    public PageDTO<QueryCheckPointListDoBO> queryCheckPointList(QueryCheckPointListQueryDoBO checkPointList) {
        PageDTO<QueryCheckPointListDoBO> resultPage = new PageDTO<>();
        QueryCheckPointListDoBO resultDTO = new QueryCheckPointListDoBO();
        log.info("接口 queryCheckPointList ,接受参数:{}", checkPointList);
        BaseResponse<IFWPageInfo<QueryCheckPointListDTO>> response = checkpoinAssetFacade.queryCheckPointList(IFWBeanCopyUtil.map(checkPointList, QueryCheckPointListQueryDTO.class));
        log.info("接口 queryCheckPointList ,返回结果:{}", response);
        if (!response.isFlag()){
            throw new BizException(response.getRetMsg(),response.getRetCode());
        }
        if (response.getData() != null){
            BeanUtils.copyProperties(response.getData(),resultPage,"list");
            resultPage.setResult(IFWBeanCopyUtil.mapAsList(response.getData().getList(),QueryCheckPointListDoBO.class));
        }
        return resultPage;
    }
}
