package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.dbm.asset.dto.file.SeerFileQuDTO;
import com.ifourthwall.dbm.sentry.bo.FileExportBO;
import com.ifourthwall.dbm.sentry.bo.SeerFileQuBO;
import com.ifourthwall.dbm.sentry.service.SentryFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.OutputStream;
import java.net.URLEncoder;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "Sentry表格相关接口", value = "SeerFileController")
@RequestMapping("/dbm/sentry/file")
public class SentryFileController {

    @Resource(name = "SentryFileServiceImpl")
    private SentryFileService fileService;

    @ApiOperation(value = "seer下载数据点位",notes = "杨鹏")
    @PostMapping("/download")
    public ResponseEntity<BaseResponse<String>> download(@Valid @RequestBody SeerFileQuDTO query, IFWUser user, HttpServletResponse response){
        log.info("接口 download 接受参数:{}",query);
        FileExportBO filePath = fileService.download(query,user);
        String fileName = filePath.getFilename() + ".xls";
        response.reset();//清缓存，设置不缓存
        response.setContentType("application/vnd.ms-excel;charset=utf-8");//文件客户端按.xls来解析文档
        //告知客户端为下载类型文件
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.setHeader("Access-Control-Allow-Origin", "*");
            OutputStream os = response.getOutputStream();
            filePath.getFile().write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        //防止名字无法解析，告诉前端文件名字
        BaseResponse<String> result = new BaseResponse<>();
        try {
            result.setData(filePath.getFilename());
            result.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            result.setRetCode(bizException.getCode());
            result.setRetMsg(bizException.getMessage());
            result.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            result.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            result.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            result.setFlag(false);
        }
        return ResponseEntity.ok(result);
    }

    @ApiOperation(value = "seer通过点位下载数据点位",notes = "杨鹏")
    @PostMapping("/download/by/datapoint/id")
    public ResponseEntity<BaseResponse<String>> downloadByDataPoint(@Valid @RequestBody SeerFileQuBO query, IFWUser user, HttpServletResponse response){
        log.info("接口 downloadByDataPoint 接受参数:{}",query);
        FileExportBO filePath = fileService.downloadByDataPoint(query,user);
        String fileName = filePath.getFilename() + ".xls";
        response.reset();//清缓存，设置不缓存
        response.setContentType("application/vnd.ms-excel;charset=utf-8");//文件客户端按.xls来解析文档
        //告知客户端为下载类型文件
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.setHeader("Access-Control-Allow-Origin", "*");
            OutputStream os = response.getOutputStream();
            filePath.getFile().write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        //防止名字无法解析，告诉前端文件名字
        BaseResponse<String> result = new BaseResponse<>();
        try {
            result.setData(filePath.getFilename());
            result.setRetCode(PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        } catch (BizException bizException) {
            result.setRetCode(bizException.getCode());
            result.setRetMsg(bizException.getMessage());
            result.setFlag(false);
        } catch (Throwable e) {
            log.error("系统异常", e);
            result.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
            result.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
            result.setFlag(false);
        }
        return ResponseEntity.ok(result);
    }

}
