package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListDTO;
import com.ifourthwall.dbm.asset.dto.app.QueryAssetAppListQuDTO;
import com.ifourthwall.dbm.sentry.service.SentryAppService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/8 16:08
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "Sentry-App接口相关接口", value = "SentryAppController")
@RequestMapping("/dbm/sentry/app")
public class SentryAppController {

    @Resource(name = "SentryAppServiceImpl")
    private SentryAppService assetAppService;

    @ApiOperation(value = "通过资产查询资产及抄表信息",notes = "杨鹏")
    @PostMapping("/query/asset/list")
    public ResponseEntity<BaseResponse<List<QueryAssetAppListDTO>>> queryAssetAppList(@Valid @RequestBody QueryAssetAppListQuDTO assetList, IFWUser user){
        log.info("接口 queryAssetAppList 接受参数:{}",assetList);
        BaseResponse<List<QueryAssetAppListDTO>> response = assetAppService.queryAssetAppList(assetList,user);
        log.info("接口 queryAssetAppList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

}
