package com.ifourthwall.dbm.sentry.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.sentry.bo.UpMonitorRecordDoBO;
import com.ifourthwall.dbm.sentry.service.MonitorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:47
 * @Description:
 */
@RestController
@Slf4j
@Api(tags = "Sentry相关接口", value = "MonitorController")
@RequestMapping("/dbm/sentry")
public class MonitorController {

    @Resource(name = "MonitorServiceImpl")
    private MonitorService monitorService;

    @ApiOperation(value = "新增/修改监控",notes = "杨鹏")
    @PostMapping("/upinsert")
    public ResponseEntity<BaseResponse> upInsertMonitor(@Valid @RequestBody UpInsertMonitorBasisDTO upInsertMonitor, IFWUser user){
        log.info("接口 upInsertMonitor 接受参数:{}",upInsertMonitor);
        BaseResponse response = monitorService.upInsertMonitor(upInsertMonitor,user);
        log.info("接口 upInsertMonitor 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "删除监控",notes = "杨鹏")
    @PostMapping("/delete")
    public ResponseEntity<BaseResponse> deleteMonitor(@Valid @RequestBody DeleteMonitorDTO delete, IFWUser user){
        log.info("接口 deleteMonitor 接受参数:{}",delete);
        BaseResponse response = monitorService.deleteMonitor(delete,user);
        log.info("接口 deleteMonitor 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


    @ApiOperation(value = "更新哥斯拉信息",notes = "杨鹏")
    @PostMapping("/upinsert/index")
    public ResponseEntity<BaseResponse> upInsertIndex(@Valid @RequestBody UpInsertMonitorBasisDTO upInsertMonitor, IFWUser user){
        log.info("接口 upInsertIndex 接受参数:{}",upInsertMonitor);
        BaseResponse response = monitorService.upInsertIndex(upInsertMonitor,user);
        log.info("接口 upInsertIndex 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询监控信息（不包括哥斯拉信息）",notes = "杨鹏")
    @PostMapping("/query/info")
    public ResponseEntity<BaseResponse<QueryMonitorInfoDTO>> queryMonitorInfo(@Valid @RequestBody QueryMonitorInfoQueryBasisDTO monitorInfo, IFWUser user){
        log.info("接口 queryMonitorInfo 接受参数:{}",monitorInfo);
        BaseResponse response = monitorService.queryMonitorInfo(monitorInfo,user);
        log.info("接口 queryMonitorInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询监控列表",notes = "杨鹏")
    @PostMapping("/query/list")
    public ResponseEntity<BaseResponse<PageDTO<QueryMonitorListDTO>>> queryMonitorList(@Valid @RequestBody QueryMonitorListQueryDTO monitorList, IFWUser user){
        log.info("接口 queryMonitorList 接受参数:{}",monitorList);
        BaseResponse response = monitorService.queryMonitorList(monitorList,user);
        log.info("接口 queryMonitorList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询监控翻译配置",notes = "杨鹏")
    @PostMapping("/query/translation")
    public ResponseEntity<BaseResponse<QueryMonitorTranslationDTO>> queryMonitorTranslation(@Valid @RequestBody TranslationDTO translationDTO){
        log.info("接口 queryMonitorTranslation 接受参数:{}",translationDTO);
        BaseResponse response = monitorService.queryMonitorTranslation(translationDTO);
        log.info("接口 queryMonitorTranslation 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询监控记录列表",notes = "杨鹏")
    @PostMapping("/query/record/list")
    public ResponseEntity<BaseResponse<PageDTO<QueryRecordingListDTO>>> queryRecordingList(@Valid @RequestBody QueryRecordingQueryBasisDTO recording,IFWUser user){
        log.info("接口 queryRecordingList 接受参数:{}",recording);
        BaseResponse response = monitorService.queryRecordingList(recording,user);
        log.info("接口 queryRecordingList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


    @ApiOperation(value = "新增告警通知（透传哥斯拉）",notes = "杨鹏")
    @PostMapping("/inset/data/point")
    public ResponseEntity<BaseResponse> insetAlertNotice(@RequestBody @Valid InsetAlertNoticeDTO insetAlertNotice,IFWUser user){
        log.info("接口 insetAlertNotice 接受参数:{}",insetAlertNotice);
        BaseResponse response = monitorService.insetAlertNotice(insetAlertNotice,user);
        log.info("接口 insetAlertNotice 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "告警通知列表",notes = "杨鹏")
    @PostMapping("/query/alert/list")
    public ResponseEntity<BaseResponse<PageDTO<AlertListDTO>>> alertList(@RequestBody @Valid AlertListQueryDTO alertList,IFWUser user){
        log.info("接口 alertList 接受参数:{}",alertList);
        BaseResponse response = monitorService.alertList(alertList,user);
        log.info("接口 alertList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "编辑告警规则",notes = "杨鹏")
    @PostMapping("/update/alert")
    public ResponseEntity<BaseResponse> updateAlert(@RequestBody @Valid UpAlertNoticeDTO updateAlert,IFWUser user){
        log.info("接口 updateAlert 接受参数:{}",updateAlert);
        BaseResponse response = monitorService.updateAlert(updateAlert,user);
        log.info("接口 updateAlert 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "告警规则详情",notes = "杨鹏")
    @PostMapping("/query/alert/info")
    public ResponseEntity<BaseResponse<QueryAlertInfoDTO>> queryAlert(@RequestBody @Valid QueryAlertDTO alertInfo,IFWUser user){
        log.info("接口 queryAlert 接受参数:{}",alertInfo);
        BaseResponse response = monitorService.queryAlert(alertInfo,user);
        log.info("接口 queryAlert 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "删除告警规则",notes = "杨鹏")
    @PostMapping("/delete/alert")
    public ResponseEntity<BaseResponse> deleteAlert(@RequestBody @Valid QueryAlertDTO alertInfo,IFWUser user){
        log.info("接口 deleteAlert 接受参数:{}",alertInfo);
        BaseResponse response = monitorService.deleteAlert(alertInfo,user);
        log.info("接口 deleteAlert 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "获取AppId",notes = "杨鹏")
    @PostMapping("/get/app/id")
    public ResponseEntity<BaseResponse> getAppId(@RequestBody @Valid GetAppIdDTO appIdDTO,IFWUser user){
        log.info("接口 getAppId 接受参数:{}",appIdDTO);
        BaseResponse response = monitorService.getAppId(appIdDTO,user);
        log.info("接口 getAppId 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "监控指标详情(sentry数据)",notes = "杨鹏")
    @PostMapping("/query/alert/index/sentry")
    public ResponseEntity<BaseResponse<AlertIndexInfoDTO>> sentryInfo(@RequestBody @Valid SentryInfoQuBasisDTO sentryInfo,IFWUser user){
        log.info("接口 sentryInfo 接受参数:{}",user);
        BaseResponse response = monitorService.sentryInfo(sentryInfo,user);
        log.info("接口 sentryInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "监控指标详情(哥斯拉数据)",notes = "杨鹏")
    @PostMapping("/query/alert/index/godzilla")
    public ResponseEntity<BaseResponse<MetricValueRecordListDTO>> godzillaInfo(@RequestBody @Valid GodzillaInfoQuDTO godzillaInfoQu,IFWUser user){
        log.info("接口 godzillaInfo 接受参数:{}",godzillaInfoQu);
        BaseResponse response = monitorService.godzillaInfo(godzillaInfoQu,user);
        log.info("接口 godzillaInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询appId",notes = "杨鹏")
    @PostMapping("/query/app/id")
    public ResponseEntity<BaseResponse<QueryAppIdDTO>> queryAppId(@RequestBody @Valid QueryAppIdQueryDTO query,IFWUser user){
        log.info("接口 queryAppId 接受参数:{}",query);
        BaseResponse response = monitorService.queryAppId(query,user);
        log.info("接口 queryAppId 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry统计信息(设备统计)",notes = "杨鹏")
    @PostMapping("/query/sentry/info/asset")
    public ResponseEntity<BaseResponse<QuerySentryInfoAssetDTO>> querySentryInfoAsset(@RequestBody @Valid QuerySentryInfoQueryDTO sentryInfo,IFWUser user){
        log.info("接口 querySentryInfoAsset 接受参数:{}",sentryInfo);
        BaseResponse response = monitorService.querySentryInfoAsset(sentryInfo,user);
        log.info("接口 querySentryInfoAsset 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry统计信息（7日告警）",notes = "杨鹏")
    @PostMapping("/query/sentry/info/seven/day")
    public ResponseEntity<BaseResponse<QuerySentryInfoSevenDayDTO>> querySentryInfoSevenDay(@RequestBody @Valid QuerySentryInfoQueryDTO sentryInfo,IFWUser user){
        log.info("接口 querySentryInfoSevenDay 接受参数:{}",sentryInfo);
        BaseResponse response = monitorService.querySentryInfoSevenDay(sentryInfo,user);
        log.info("接口 querySentryInfoSevenDay 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry统计信息（告警排行）",notes = "杨鹏")
    @PostMapping("/query/sentry/info/ranking")
    public ResponseEntity<BaseResponse<SentryInfoRankingDTO>> querySentryInfoRanking(@RequestBody @Valid QuerySentryInfoQueryDTO sentryInfo,IFWUser user){
        log.info("接口 querySentryInfoRanking 接受参数:{}",sentryInfo);
        BaseResponse response = monitorService.querySentryInfoRanking(sentryInfo,user);
        log.info("接口 querySentryInfoRanking 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry统计信息（设备完好率）",notes = "杨鹏")
    @PostMapping("/query/sentry/info/intact")
    public ResponseEntity<BaseResponse<SentryInfoIntactDTO>> querySentryInfoIntact(@RequestBody @Valid QuerySentryInfoQueryDTO sentryInfo,IFWUser user){
        log.info("接口 querySentryInfoIntact 接受参数:{}",sentryInfo);
        BaseResponse response = monitorService.querySentryInfoIntact(sentryInfo,user);
        log.info("接口 querySentryInfoIntact 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "seer系统统计列表",notes = "杨鹏")
    @PostMapping("/query/seer/tag/list")
    public ResponseEntity<BaseResponse<IFWPageInfo<SeerTagListDTO>>> seerTagList(@RequestBody @Valid QuerySentryInfoQueryDTO sentryInfo, IFWUser user){
        log.info("接口 seerTagList 接受参数:{}",sentryInfo);
        BaseResponse response = monitorService.seerTagList(sentryInfo,user);
        log.info("接口 seerTagList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry实时监控图-检测设备总数",notes = "杨鹏")
    @PostMapping("/query/asset/monitor")
    public ResponseEntity<BaseResponse<SentryMonitorRankingDTO>> sentryMonitor(@RequestBody @Valid SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user){
        log.info("接口 sentryMonitor 接受参数:{}",rankingQuDTO);
        BaseResponse response = monitorService.sentryMonitor(rankingQuDTO,user);
        log.info("接口 sentryMonitor 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry实时监控图-故障排行",notes = "杨鹏")
    @PostMapping("/query/asset/rank")
    public ResponseEntity<BaseResponse<SentryRankDTO>> sentryRanking(@RequestBody @Valid SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user){
        log.info("接口 sentryRanking 接受参数:{}",rankingQuDTO);
        BaseResponse response = monitorService.sentryRanking(rankingQuDTO,user);
        log.info("接口 sentryRanking 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


    @ApiOperation(value = "sentry实时监控图-系统列表",notes = "杨鹏")
    @PostMapping("/query/tag/list")
    public ResponseEntity<BaseResponse<List<TagInfoDTO>>> tagInfo(@RequestBody @Valid TagInfoQuDTO tagQuery, IFWUser user){
        log.info("接口 tagInfo 接受参数:{}",tagQuery);
        BaseResponse response = monitorService.tagInfo(tagQuery,user);
        log.info("接口 tagInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry实时监控图-系统故障百分比",notes = "杨鹏")
    @PostMapping("/query/tag/percent")
    public ResponseEntity<BaseResponse<TagFaultPercentDTO>> tagFaultPercent(@RequestBody @Valid TagFaultPercentQuDTO percentQuery, IFWUser user){
        log.info("接口 tagFaultPercent 接受参数:{}",percentQuery);
        BaseResponse response = monitorService.tagFaultPercent(percentQuery,user);
        log.info("接口 tagFaultPercent 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry实时监控图-空间筛选",notes = "杨鹏")
    @PostMapping("/query/space/list")
    public ResponseEntity<BaseResponse<List<MonitorSpaceDTO>>> monitorSpace(@RequestBody @Valid MonitorSpaceQuDTO spaceQu, IFWUser user){
        log.info("接口 monitorSpace 接受参数:{}",spaceQu);
        BaseResponse response = monitorService.monitorSpace(spaceQu,user);
        log.info("接口 monitorSpace 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询调用授权数量",notes = "杨鹏")
    @PostMapping("/query/transfer/number")
    public ResponseEntity<BaseResponse<TransferNumberDTO>> transferNumber(@RequestBody @Valid TransferNumberQuDTO appId, IFWUser user){
        log.info("接口 transferNumber 接受参数:{}",appId);
        BaseResponse response = monitorService.transferNumber(appId,user);
        log.info("接口 transferNumber 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "新增监控对象标签",notes = "杨鹏")
    @PostMapping("/insert/tag")
    public ResponseEntity<BaseResponse> insertTag(@RequestBody @Valid InsertTagQuDTO insertTag, IFWUser user){
        log.info("接口 insertTag 接受参数:{}",insertTag);
        BaseResponse response = monitorService.insertTag(insertTag,user);
        log.info("接口 insertTag 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "修改监控对象标签",notes = "杨鹏")
    @PostMapping("/update/tag")
    public ResponseEntity<BaseResponse> updateTag(@RequestBody @Valid UpdateTagQuDTO updateTag, IFWUser user){
        log.info("接口 updateTag 接受参数:{}",updateTag);
        BaseResponse response = monitorService.updateTag(updateTag,user);
        log.info("接口 updateTag 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "删除监控对象标签",notes = "杨鹏")
    @PostMapping("/delete/tag")
    public ResponseEntity<BaseResponse> deleteTag(@RequestBody @Valid DeleteTagQuDTO deleteTag, IFWUser user){
        log.info("接口 deleteTag 接受参数:{}",deleteTag);
        BaseResponse response = monitorService.deleteTag(deleteTag,user);
        log.info("接口 deleteTag 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询监控对象标签",notes = "杨鹏")
    @PostMapping("/query/monitor/tag/list")
    public ResponseEntity<BaseResponse<IFWPageInfo<QueryMonitorTagListDTO>>> queryTagList(@RequestBody @Valid QueryMonitorTagListQuDTO queryList, IFWUser user){
        log.info("接口 queryTagList 接受参数:{}",queryList);
        BaseResponse response = monitorService.queryTagList(queryList,user);
        log.info("接口 queryTagList 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry实时监控图-告警次数排行",notes = "杨鹏")
    @PostMapping("/query/asset/number/rank")
    public ResponseEntity<BaseResponse<alertNumberRanking>> alertNumberRanking(@RequestBody @Valid SentryMonitorRankingQuDTO rankingQuDTO, IFWUser user){
        log.info("接口 alertNumberRanking 接受参数:{}",rankingQuDTO);
        BaseResponse response = monitorService.alertNumberRanking(rankingQuDTO,user);
        log.info("接口 alertNumberRanking 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "sentry实时监控图首页-监控设备统计",notes = "杨鹏")
    @PostMapping("/query/monitor/seer/info")
    public ResponseEntity<BaseResponse<monitorSeerInfoDTO>> monitorSeerInfo(@RequestBody @Valid monitorSeerInfoQuDTO query, IFWUser user){
        log.info("接口 monitorSeerInfo 接受参数:{}",query);
        BaseResponse response = monitorService.monitorSeerInfo(query,user);
        log.info("接口 monitorSeerInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "seer查询sentry监控",notes = "杨鹏")
    @PostMapping("/seer/query/sentry/info")
    public ResponseEntity<BaseResponse<SeerQuerySentryInfoDTO>> seerQuerySentryInfo(@RequestBody @Valid SeerQuerySentryInfoQuDTO query, IFWUser user){
        log.info("接口 seerQuerySentryInfo 接受参数:{}",query);
        BaseResponse response = monitorService.seerQuerySentryInfo(query,user);
        log.info("接口 seerQuerySentryInfo 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }

    @ApiOperation(value = "查询是否存在工单",notes = "杨鹏")
    @PostMapping("/query/task")
    public ResponseEntity<BaseResponse<Boolean>> sentryQueryTask(@RequestBody @Valid SentryQueryTaskQuDTO query, IFWUser user){
        log.info("接口 sentryQueryTask 接受参数:{}",query);
        BaseResponse response = monitorService.sentryQueryTask(query,user);
        log.info("接口 sentryQueryTask 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }


    @ApiOperation(value = "查询用电用水信息",notes = "杨鹏")
    @PostMapping("/query/all/by/statistics")
    public ResponseEntity<BaseResponse<QueryAllByStatisticsDTO>> queryAllByStatistics(@RequestBody @Valid QueryAllByStatisticsQuDTO query, IFWUser user){
        log.info("接口 queryAllByStatistics 接受参数:{}",query);
        BaseResponse response = monitorService.queryAllByStatistics(query,user);
        log.info("接口 queryAllByStatistics 返回参数:{}",response);
        return ResponseEntity.ok(response);
    }



}
