package com.ifourthwall.dbm.sentry.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Data
@Configuration
@Component
@ConfigurationProperties(prefix = "ifw.dashboard.asset.tag")
@PropertySource(value = {"classpath:application.properties"},encoding = "utf-8")
public class AssetTagConfig {

    private Map<String, String> in = new HashMap<>();

    private Map<String, String> out = new HashMap<>();

}
