package com.ifourthwall.dbm.sentry.bo;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 09:52
 * @Description:
 */
@Data
public class UpInsertMonitorDoBO extends BaseReqDTO {

    @ApiModelProperty("操作类型:1.新增；2.修改")
    @NotNull(message = "操作类型不能为空")
    private Integer type;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("监控对象描述")
    private String monitorTargetDesc;

    @ApiModelProperty("是否自动发起工单 0.发 1不发")
    private String autoCreateTemporaryTaskId;

    @ApiModelProperty("工单模板id")
    private String taskTemplateId;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("监控点信息")
    @Valid
    private List<MonitorMetricDoBO> monitorMetricInfo;

    @ApiModelProperty("监控指标id，修改时需要")
    private String monitorMetricId;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

    @ApiModelProperty("哥斯拉设备id")
    private String deviceId;

    @ApiModelProperty("监控对象标签id")
    private String monitorTargetTagId;
}
