package com.ifourthwall.dbm.sentry.bo;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.dbm.project.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/19 09:46
 * @Description:
 */
@Data
public class QueryRecordingQueryDoBO extends PageCommonExTDTO {

    @ApiModelProperty("1.未处理 2.处理中 3.完成 4.无工单")
    private Integer taskStatusId;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("空间id")
    private List<String> spaceId;

    @ApiModelProperty("租户id")
    @NotNull(message = "租户id不能为空")
    private String tenantId;

    @ApiModelProperty("监控名字")
    private String assetName;

    @ApiModelProperty("开始时间")
    private String beginTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

    @ApiModelProperty("监控记录id")
    private String monitorId;

    @ApiModelProperty("资产id")
    protected String assetId;

    @ApiModelProperty("系统id")
    private String assetSystemId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("抄表")
    private String assetEnableCheckMeter;

//    @ApiModelProperty("排序 1逆序，2顺序")
//    private String sort;
}
