package com.ifourthwall.dbm.sentry.bo;

import com.ifourthwall.dbm.asset.dto.GodzillaBindingInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/16 18:25
 * @Description:
 */
@Data
public class QueryMonitorListDoBO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("监控对象名")
    private String assetName;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("项目空间名字")
    private String projectSpaceName;

    @ApiModelProperty("资产编号")
    private String assetCode;

    @ApiModelProperty("点位图片")
    private String pictureUrl;


    @ApiModelProperty("是否自动发起工单 0.发 1不发")
    private String autoCreateTemporaryTaskId;

    @ApiModelProperty("资产状态 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("资产状态")
    private String assetStatusName;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("哥斯拉绑定信息")
    private List<GodzillaBindingInfo> godzillaInfo;

    @ApiModelProperty("系统id")
    private String assetSystemId;

    @ApiModelProperty("系统名称")
    private String systemName;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("设备类型名称")
    private String equipmentTypeName;

    @ApiModelProperty("监控类型0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("监控类型")
    private String assetCategoryName;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;
}
