package com.ifourthwall.dbm.sentry.bo;

import com.ifourthwall.dbm.asset.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/3 14:58
 * @Description:
 */
@Data
public class QueryAssetListQueryBO extends PageCommonExTDTO {

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目id")
    @NotNull(message = "项目id不能为空")
    private String projectId;

    @ApiModelProperty("空间id")
    private List<String> spaceId;

    @ApiModelProperty("资产类型 0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("排序 1逆序，2顺序")
    private String sort;

    @ApiModelProperty("资产状态 1.正常;2.异常;3.异常")
    private String assetStatus;

    @ApiModelProperty("资产名字")
    private String assetName;


}
