package com.ifourthwall.dbm.sentry.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2019/12/3 14:52
 * @Description:
 */
@Data
public class QueryAssetInfoBO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("资产名称")
    private String assetName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("项目空间名称")
    private String projectSpaceName;

    @ApiModelProperty("u3d模型id")
    private String u3dModelId;

    @ApiModelProperty("资产状态 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("资产状态名称")
    private String assetStatusName;

    @ApiModelProperty("资产编号")
    private String assetCode;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("资产分类名称")
    private String assetCategoryName;

    @ApiModelProperty("生产厂家")
    private String factory;

    @ApiModelProperty("资产类型")
    private String assetType;

    @ApiModelProperty("生产日期")
    private Date manufactureDate;

    @ApiModelProperty("资产型号")
    private String assetModel;

    @ApiModelProperty("使用年限")
    private Integer assetLifetime;

    @ApiModelProperty("购买时间")
    private Date purchaseTime;

    @ApiModelProperty("资产原值 元")
    private BigDecimal assetOriginalValue;

    @ApiModelProperty("维保供应商名称")
    private String maintenanceSupplierName;

    @ApiModelProperty("维保供应商电话")
    private String maintenanceSupplierTel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("创建者名字")
    private String createName;

}
