package com.ifourthwall.dbm.sentry.bo;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ToString(callSuper=true)
public class ProjectSpaceSubListQueryDoBO extends BaseReqDTO {

    @ApiModelProperty("空间id集合")
    private List<String> ids;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("父级id")
    private List<String> pid;

    @ApiModelProperty("名字搜索")
    private String nameLike;

    @ApiModelProperty("搜索的模块名称")
    private String modelName;

    @ApiModelProperty("等级")
    private Integer spaceLvl;

}
