package com.ifourthwall.dbm.sentry.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
public class ProjectSpacePathBO implements Serializable {

    @ApiModelProperty(value = "空间id")
    private String id;

    @ApiModelProperty(value = "空间id对应的名字")
    private String name = "";

    @ApiModelProperty(value = "父级id集合")
    private List<String> pids = new ArrayList<>();

    @ApiModelProperty(value = "父级空间名字")
    private List<String> pnames = new ArrayList<>();

    @ApiModelProperty(value = "拼接好的空间名字")
    private String nameStr = "";

    @ApiModelProperty(value = "模型层级id1")
    private String modelOne;

    @ApiModelProperty(value = "模型层级名称1")
    private String  modelNameOne;

    @ApiModelProperty(value = "模型层级id2")
    private String modelTwo;

    @ApiModelProperty(value = "模型层级名称2")
    private String modelNameTwo;

    @ApiModelProperty(value = "模型层级id3")
    private String modelThree;

    @ApiModelProperty(value = "模型层级名称3")
    private String modelNameThree;

    @ApiModelProperty(value = "模型层级id4")
    private String modelFour;

    @ApiModelProperty(value = "模型层级名称4")
    private String modelNameFour;

    private Integer level;

    public ProjectSpacePathBO(String id) {
        this.id = id;
    }

    public ProjectSpacePathBO() {
    }

}
