package com.ifourthwall.message.sms.config;

import com.ifourthwall.message.sms.SendSMSService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: hao.dai
 * @Date: 2019/12/27 16:09
 * @Description:
 */
@Configuration
@ConditionalOnProperty(prefix = "ifw.sms.config", name = "enable", havingValue = "true", matchIfMissing = false)
@EnableConfigurationProperties(value = {SMSProperty.class})
public class SendSMSConfig {
    @Autowired
    private SMSProperty smsProperty;

    @Bean
    public SendSMSService sendSMSService() {
        if (CollectionUtils.isEmpty(smsProperty.getConfig())) {
            throw new IllegalArgumentException("sms配置不存在");
        }
        Map<String, List<SMSProperties>> smsPropertiesMap = new HashMap<>();
        List<SMSProperties> defaultSMSProperties = new ArrayList<>();

        for (SMSProperties smsProperties : smsProperty.getConfig()) {
            List<SMSProperties> smsPropertiesList = smsPropertiesMap.get(smsProperties.getCountryCode());
            if (CollectionUtils.isEmpty(smsPropertiesList)) {
                smsPropertiesList = new ArrayList<>();
                smsPropertiesList.add(smsProperties);
                smsPropertiesMap.put(smsProperties.getCountryCode(), smsPropertiesList);
            } else {
                smsPropertiesList.add(smsProperties);
            }

            //获取默认 默认国家和模板
            if (smsProperties.isAsDefaultTemplate() && smsProperties.isDefaultSelected()) {
                defaultSMSProperties.add(smsProperties);
            }
        }
        //默认配置只有一个
        if (CollectionUtils.isEmpty(defaultSMSProperties)) {
            throw new IllegalArgumentException("未设置指定默认模板");
        }
        SendSMSService sendSMSService = new SendSMSService(smsPropertiesMap, defaultSMSProperties);

        return sendSMSService;
    }
}
