/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.kafka;

import com.ifourthwall.kafka.KafkaProducerCallBack;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class IFWKafkaClient {
    private static final Logger log = LoggerFactory.getLogger(IFWKafkaClient.class);
    private KafkaTemplate<String, Object> kafkaTemplate;
    private String topic;

    public IFWKafkaClient(KafkaTemplate<String, Object> kafkaTemplate, String topic) {
        this.kafkaTemplate = kafkaTemplate;
        this.topic = topic;
    }

    public boolean produce(final String alertMsg, final KafkaProducerCallBack callBack) {
        log.info("\u5199\u5165kafka produce data=" + alertMsg);
        ListenableFuture future = this.kafkaTemplate.send(this.topic, (Object)alertMsg);
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<SendResult<String, Object>>(){

            public void onSuccess(SendResult<String, Object> result) {
                callBack.succeed(result);
            }

            public void onFailure(Throwable ex) {
                callBack.failed(alertMsg, ex);
            }
        });
        return true;
    }

    public void syncProduce(String data) {
        log.info("\u540c\u6b65\u5199\u5165kafka produce data={}", (Object)data);
        try {
            this.kafkaTemplate.send(this.topic, (Object)data).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

