/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.kafka;

import com.ifourthwall.kafka.DataHandler;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.util.CollectionUtils;

@KafkaListener(containerFactory="MessageListenerContainer")
public class KafkaDataConsumer
implements AcknowledgingConsumerAwareMessageListener {
    private static final Logger log = LoggerFactory.getLogger(KafkaDataConsumer.class);
    private List<DataHandler> dataHandlerList;

    public KafkaDataConsumer(List<DataHandler> dataHandlerList) {
        this.dataHandlerList = dataHandlerList;
    }

    public void onMessage(ConsumerRecord data, Acknowledgment acknowledgment, Consumer consumer) {
        log.info("kafka\u6d88\u8d39\u63a5\u53d7\u5230\u6570\u636e:{}", data.value());
        consumer.commitSync();
        try {
            if (!CollectionUtils.isEmpty(this.dataHandlerList)) {
                for (DataHandler dataHandler : this.dataHandlerList) {
                    if (!dataHandler.judge(data.topic())) continue;
                    dataHandler.handle(data.value().toString());
                }
            }
            consumer.commitSync();
            log.info("\u5904\u7406\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            log.error("kafka\u6d88\u8d39\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:", (Throwable)e);
        }
    }

    public void onMessage(Object data) {
    }
}

