/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.aop.aop;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class WebLogAspect {
    @Autowired
    private Environment env;
    private static final Logger logger = LoggerFactory.getLogger(WebLogAspect.class);

    @Pointcut(value="execution(public * com.ifourthwall..*Controller.*(..))")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestId = request.getHeader("requestId");
        String dataId = this.env.getProperty("nacos.config.data-id");
        logger.info("========================================== Start ==========================================");
        logger.info("nacos.config.data-id            : {}", (Object)dataId);
        logger.info("URL            : {}", (Object)request.getRequestURL().toString());
        logger.info("traceId        : {}", (Object)TraceContext.traceId());
        logger.info("HTTP Method    : {}", (Object)request.getMethod());
        logger.info("Class Method   : {}.{}", (Object)joinPoint.getSignature().getDeclaringTypeName(), (Object)joinPoint.getSignature().getName());
        logger.info("IP             : {}", (Object)request.getRemoteAddr());
        logger.info("Request Args   : {}", joinPoint.getArgs());
    }

    @After(value="webLog()")
    public void doAfter() throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        HttpServletResponse response = attributes.getResponse();
        logger.info("\u8fd4\u56de1  : {}", request.getAttribute("result"));
        logger.info("\u8fd4\u56de2  : {}", (Object)response.getWriter().toString());
        logger.info("=========================================== End ===========================================");
    }
}

