/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.aop.aop;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={BizException.class})
    @ResponseBody
    public ResponseEntity<BaseResponse> handleBizException(BizException e) {
        log.warn("Controller\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setRetCode(e.getCode());
        baseResponse.setRetMsg(e.getMessage());
        baseResponse.setFlag(false);
        return ResponseEntity.ok((Object)baseResponse);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<BaseResponse> handleException(Exception e) {
        log.error("Controller\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException paramExp = (MethodArgumentNotValidException)e;
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.setRetCode(PlatformCodeEnum.VALIDATION_ERROR.getCode());
            baseResponse.setRetMsg(paramExp.getBindingResult().getFieldError().getDefaultMessage());
            baseResponse.setFlag(false);
            return ResponseEntity.ok((Object)baseResponse);
        }
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setRetCode(PlatformCodeEnum.SYS_ERROR.getCode());
        baseResponse.setRetMsg(PlatformCodeEnum.SYS_ERROR.getDesc());
        baseResponse.setFlag(false);
        return ResponseEntity.ok((Object)baseResponse);
    }
}

