package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.QueryPurchaseServiceReqDTO;
import com.ifourthwall.dbm.user.dto.QueryPurchaseServiceResDTO;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020/2/18 14:48
 * @Description:
 */
public interface TenantPurchaseServiceFacade  {

    /**
     * 查询租户已购买的服务名字和最大账号使用的数量
     * @Param: [queryPurchaseServiceReqBO]
     * @Return: com.ifourthwall.common.base.BaseResponse <java.util.List< com.ifourthwall.dbm.user.dto.QueryPurchaseServiceResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/18 15:10
     */
    BaseResponse<List<QueryPurchaseServiceResDTO>> queryPurchaseService(QueryPurchaseServiceReqDTO queryPurchaseServiceReqDTO);

    /**
     * 查询后台租户已购买的服务名字和最大账号使用的数量
     * @Param: [queryPurchaseServiceReqBO]
     * @Return: com.ifourthwall.common.base.BaseResponse <java.util.List< com.ifourthwall.dbm.user.dto.QueryPurchaseServiceResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/18 15:10
     */
    BaseResponse<List<QueryPurchaseServiceResDTO>> queryAdminPurchaseService(QueryPurchaseServiceReqDTO queryPurchaseServiceReqDTO);
}
