package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;


/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 17:44 2019/10/30
 * @Modified By:
 */
public interface TenantFacade {
    /**
     * 新增租户
     * @Param: [tenantDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @Author: daixingqiang
     * @Date: 2019/10/30 18:06
     */
    BaseResponse<TenantDTO> saveTenant(TenantDTO tenantDTO);

    /**
     * 删除租户id
     * @Param: [tenantId]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @Author: daixingqiang
     * @Date: 2019/10/30 18:23
     */
    BaseResponse<TenantDTO> deleteTenant(TenantDTO tenantDTO);

    /**
     * 查询租户详情
     * @Param: [tenantId]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.TenantDTO>
     * @Author: daixingqiang
     * @Date: 2019/10/31 9:46
     */
    BaseResponse<TenantDTO> queryTenant(TenantDTO tenantDTO);


    /**
     * 修改租户信息
     * @Param: [tenantDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>
     * @Author: daixingqiang
     * @Date: 2019/10/31 14:15
     */
    BaseResponse<TenantDTO> updateTenant(TenantDTO tenantDTO);

    /**
     * 租户列表
     * @Param: []
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.TenantDTO>
     * @Author: daixingqiang
     * @Date: 2019/10/31 14:44
     */

    BaseResponse<PageResponseDTO<TenantDTO>> queryListTenant(PageReqDTO pageReqDTO);

    /**
     * 查询租户
     * @Param: [queryTenantReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List< com.ifourthwall.dbm.user.dto.QueryTenantResDTO>>
     * @Author: tanglei
     * @Date: 2020/3/13 14:48
     */
    BaseResponse<List<QueryTenantResDTO>> findTenant(QueryTenantReqDTO queryTenantReqDTO);


    BaseResponse<List<QueryTeantNameResDTO>> queryTenantNames(QueryTeantNameReqDTO queryTeantNameReqDTO);

    /**
     * uface应用绑定显示
     * @Param: [pageUfaceTenantReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.PageUfaceTenantResDTO>>>
     * @Author: tanglei
     * @Date: 2020/4/29 15:34
     */
    BaseResponse<List<QueryUfaceTenantResDTO>> queryUfaceInfos(PageUfaceTenantReqDTO pageUfaceTenantReqDTO);


}
