package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 18:13 2019/11/20
 * @Modified By:
 */
public interface SendAlertSmSFacade {
    /**
     * 手机发送注册验证码
     * @Param: [phone]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.String>
     * @Author: tangelei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendRegisteredSmS(String phone);

    /**
     * 手机登录验证码
     * @Param: [phone]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.String>
     * @Author: tanglei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendLoginSmS(String phone);


    /**
     * 邮箱发送注册验证码
     * @Param: [userDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>
     * @Author: daixingqiang
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendRegisterEmail(String email,String languageCode);

    /**
     * 邮箱发送登录验证码
     * @Param: [userDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>
     * @Author: tanglei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse<Void> sendLoginEmail(String email,String languageCode);

    /**
     * 手机找回密码
     * @Param: [phone]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.String>
     * @Author: tanglei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendPasswordSmS(String phone);


    /**
     * 邮箱找回密码
     * @Param: [email]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>
     * @Author: tanglei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendPasswordEmailSms(String email,String languageCode);


    /**
     * 发送生成的用户名和密码通过手机
     * @Param: [phone]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>
     * @Author: tangelei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendUserAndPasswordByPhone(String phone,String loginName,String userPassword);


    /**
     * 发送生成的用户名和密码通过邮箱
     * @Param: [email,loginName,userPassword]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>
     * @Author: tanglei
     * @Date: 2019/12/30 15:40
     */
    BaseResponse sendUserAndPasswordByEmail(String email,String loginName,String userPassword,String languageCode);


    /**
     * 修改手机验证码
     * @Param: [phoneLoginCodeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>>
     * @Author: daixingqiang
     * @Date: 2019/11/28 15:08
     */
    BaseResponse updateSendSms(String phone);

    /**
     * 修改邮箱验证码
     * @Param: [emailLoginCodeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.lang.Void>>
     * @Author: daixingqiang
     * @Date: 2019/11/28 15:08
     */
    BaseResponse updateSendEmail(String email, String languageCode);
}
