package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 14:48 2019/10/31
 * @Modified By:
 */
public interface RoleFacade {

    /**
     * 添加角色
     * @Param: [insertRoleDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < com.ifourthwall.dbm.user.dto.InsertRoleDTO>
     * @Author: tanglei
     * @Date: 2020/1/10 15:31
     */
    BaseResponse<InsertRoleDTO> saveRole(InsertRoleDTO insertRoleDTO);


    /**
     * 修改角色
     * @Param: [updateRoleDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.UpdateRoleDTO>
     * @Author: tanglei
     * @Date: 2020/1/10 15:31
     */
    BaseResponse<UpdateRoleDTO> updateRole(UpdateRoleDTO updateRoleDTO);


    /**
     * 删除角色
     *
     * @Param: [deleteRoleDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.DeleteRoleDTO>
     * @Author: tanglei
     * @Date: 2020/1/10 18:18
     */
    BaseResponse<DeleteRoleDTO> deleteRole(DeleteRoleDTO deleteRoleDTO);


    /**
     * 根据用户id查询角色
     * @Param: [roleId]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.RoleDTO>
     * @Author: daixingqiang
     * @Date: 2019/10/31 15:43
     */
    BaseResponse<List<RoleDTO>> queryRoleSByUserId(RoleDTO roleDTO);

    /**
     * 角色列表
     * @Param: [queryRoleReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < java.util.List <  com.ifourthwall.dbm.user.dto.QueryRoleReqDTO>>
     * @Author: tanglei
     * @Date: 2020/1/10 11:31
     */
    BaseResponse<List<QueryRoleResDTO>> queryListRole(QueryRoleReqDTO queryRoleReqDTO);

    /**
     * 通过角色Id查找module
     * @Param: [roleDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.ModuleDTO>>
     * @Author: tanglei
     * @Date: 2019/11/6 14:22
     */
    BaseResponse<List<ModuleDTO>> findModuleByRoleId(RoleIdModlesReqDTO roleIdModlesReqDTO);

    /**
     * 角色和模块绑定
     * @Param: [roleAndModuleDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.RoleAndModuleDTO>
     * @Author: tanglei
     * @Date: 2020/1/13 17:28
     */
    BaseResponse<RoleAndModuleDTO> bindingRoleAndModule(RoleAndModuleDTO roleAndModuleDTO);

    /**
     * 角色和用户绑定
     * @Param: [roleAndUserDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.RoleAndUserDTO>>
     * @Author: tanglei
     * @Date: 2020/1/13 17:28
     */
    BaseResponse<RoleAndUserDTO> bindingRoleAndUser(RoleAndUserDTO roleAndUserDTO);

    /**
     * 角色id查用户
     * @Param: [roleAndUserDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<   com.ifourthwall.dbm.user.dto.FindRoleIdByUserResDTO>>
     * @Author: tanglei
     * @Date: 2020/1/16 17:28
     */
    BaseResponse<FindRoleIdByUserResDTO> findRoleIdByUserReqDTO(FindRoleIdByUserReqDTO findRoleIdByUserReqDTO);

    /**
     * 通过用户id删除绑定角色线面的用户的
     * @Param: [roleAndUserDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<   com.ifourthwall.dbm.user.dto.DeleteRoleIdUserDTO>>
     * @Author: tanglei
     * @Date: 2020/1/16 17:28
     */
    BaseResponse<DeleteRoleIdUserDTO> deleteUserByRoleId(DeleteRoleIdUserDTO deleteRoleIdUserDTO);

    /**
     * 回显角色信息和和已分配的服务信息
     * @Param: [getRoleServiceReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.GetRoleServiceResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/20 11:46
     */
    BaseResponse<GetRoleServiceResDTO> getRoleService(GetRoleServiceReqDTO getRoleServiceReqDTO);

    /**
     * 后台的角色列表
     * @Param: [queryRoleReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < java.util.List <  com.ifourthwall.dbm.user.dto.QueryRoleReqDTO>>
     * @Author: tanglei
     * @Date: 2020/1/10 11:31
     */
    BaseResponse<List<QueryRoleResDTO>> queryAdminListRole(QueryRoleReqDTO queryRoleReqDTO);

    /**
     * 添加后台角色
     * @Param: [insertRoleDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < com.ifourthwall.dbm.user.dto.InsertRoleDTO>
     * @Author: tanglei
     * @Date: 2020/1/10 15:31
     */
    BaseResponse<InsertRoleDTO> saveAdminRole(InsertRoleDTO insertRoleDTO);
}
