package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 17:53 2019/10/29
 * @Modified By:
 */
public interface PositionFacade {

    /**
     * 新增岗位
     * @Param: [insertPositionDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < com.ifourthwall.dbm.user.dto.InsertPositionDTO>
     * @Author: tanglei
     * @Date: 2020/1/7 18:18
     */
    BaseResponse<InsertPositionDTO> savePosition(InsertPositionDTO insertPositionDTO);

    /**
     * 删除岗位
     * @Param: [deletePositionDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < com.ifourthwall.dbm.user.dto.PositionDTO>>
     * @Author: tanglei
     * @Date: 2020/1/8 11:16
     */
    BaseResponse<DeletePositionDTO> deletePosition(DeletePositionDTO positionDTO);

    /**
     * 查询岗位详细
     * @Param: [ positionId]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.PositionDTO>
     * @Author: daixingqiang
     * @Date: 2019/10/30 11:52
     */
    BaseResponse<List<UserDTO>> queryPosition(UserPositionDTO userPositionDTO);


    /**
     * 修改岗位
     * @Param: [updatePositionDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.UpdatePositionDTO>
     * @Author: tanglei
     * @Date: 2020/1/8 10:16
     */
    BaseResponse<UpdatePositionDTO> updatePosition(UpdatePositionDTO updatePositionDTO);


    /**
     * 岗位列表搜索岗位
     * @Param: [pageReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.PositionDTO>>
     * @Author: daixingqiang
     * @Date: 2019/10/30 17:23
     */
    BaseResponse<PageResponseDTO> findListPosition(PageReqDTO pageReqDTO);


    /**
     * 岗位查询
     * @Param: [findPositionByTenantIdDTO1]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.dbm.user.dto.FindPostitionByTenantIdDTO>>
     * @Author: tanglei
     * @Date: 2019/12/30 14:17
     */
    BaseResponse<List<FindPostitionByTenantIdDTO>> findListPositionByTenantId(FindPostitionByTenantIdDTO findPositionByTenantIdDTO1);

    /**
     * 根据部门id和岗位id查询当前岗位的信息
     * @Param: [getPositionDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <   com.ifourthwall.dbm.user.dto.GetPositionDTO>>
     * @Author: tanglei
     * @Date: 2020/1/7 18:18
     */
    BaseResponse<GetPositionDTO> getPosition(GetPositionDTO getPositionDTO);

    /**
     * 根据岗位id查询下面人员信息
     * @Param: [queryReqEmployeeDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.QueryResEmployeeDTO>
     * @Author: tanglei
     * @Date: 2020/1/10 14:48
     */
    BaseResponse<List<QueryResEmployeeDTO>> queryPositionAndEmployeeByPositionId(QueryReqEmployeeDTO queryReqEmployeeDTO);

    /**
     * 根据部门id查询当前岗位的名称
     * @Param: [queryPositionReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <    com.ifourthwall.dbm.user.dto.QueryPositionResDTO>
     * @Author: tanglei
     * @Date: 2020/1/7 18:18
     */
    BaseResponse<List<QueryPositionResDTO>> getPositionName(QueryPositionReqDTO queryPositionReqDTO);

    /**
     * 根据部门ids查询当前的部门和岗位的信息
     * @Param: [queryDeptPositionReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < java.util.List<com.ifourthwall.dbm.user.dto.QueryDeptPositionResDTO>>>
     * @Author: tanglei
     * @Date: 2020/1/13 14:45
     */
    BaseResponse<List<QueryDeptPositionResDTO>> queryDeptAndPositionByPositionIds(QueryDeptPositionReqDTO queryDeptPositionReqDTO);

    /**
     * 查询所有的岗位
     * @Param: [queryDeptPositionReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  java.util.List<   com.ifourthwall.dbm.user.dto.QueryPositionsResDTO>>>
     * @Author: tanglei
     * @Date: 2020/2/17 14:45
     */
    BaseResponse<List<QueryPositionsResDTO>> queryPositionsInfoByTenantId(QueryPositionsReqDTO queryDeptPositionReqDTO);

    /**
     * 根据部门ids查询岗位树
     * @Param: queryPositionTreeReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List< com.ifourthwall.dbm.user.dto.QueryPositionTreeResDTO>>>
     * @Author: tanglei
     * @Date: 2020/3/2 18:07
     */
    BaseResponse<List<QueryPositionTreeResDTO>> queryPositionTreeByDeptIds(QueryPositionTreeByDeptIdsReqDTO queryPositionTreeByDeptIdsReqDTO);

    /**
     * 根据岗位ids查询岗位名称
     * @Param: queryPositionNameReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List<  com.ifourthwall.dbm.user.dto.QueryPositionNameResDTO>>>
     * @Author: tanglei
     * @Date: 2020/3/10 18:07
     */
    BaseResponse<List<QueryPositionNameResDTO>> queryPositionNameByPositionIds(QueryPositionNameReqDTO queryPositionNameReqDTO);

    /**
     * 根据岗位ids查询部门信息
     * @Param: [queryDeptPositionReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.QueryDeptInfosResDTO>>
     * @Author: tanglei
     * @Date: 2020/3/17 14:45
     */
    BaseResponse<List<QueryDeptInfosResDTO>> queryDepotInfo(QueryDeptInfosReqDTO queryDeptPositionReqDTO);
}
