package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.DeleteOrganizationDTO;
import com.ifourthwall.dbm.user.dto.OrganizationDTO;
import com.ifourthwall.dbm.user.dto.QueryOrganizationDTO;
import com.ifourthwall.dbm.user.dto.UpdateOrganizationDTO;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 17:27 2019/11/15
 * @Modified By:
 */
public interface OrganizationFacade {

    /**
     * 添加组织信息
     * @Param: [organizationDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.QueryOrganizationDTO>
     * @Author: tanglei
     * @Date: 2019/1/3 15:39
     */
    BaseResponse<OrganizationDTO> saveOrganization(OrganizationDTO organizationDTO);

    /**
     * 修改组织信息
     * @Param: [organizationDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.UpdateOrganizationDTO>
     * @Author: tanglei
     * @Date: 2019/1/3 15:39
     */
    BaseResponse<UpdateOrganizationDTO> updateOrganization(UpdateOrganizationDTO updateOrganizationDTO);

    /**
     * 查询组织信息
     * @Param: [queryOrganizationDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <com.ifourthwall.dbm.user.dto.QueryOrganizationDTO>
     * @Author: tanglei
     * @Date: 2019/1/3 15:39
     */
    BaseResponse<QueryOrganizationDTO> queryOrganization(QueryOrganizationDTO queryOrganizationDTO);

    /**
     * 删除组织信息
     * @Param: [deleteOrganizationDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <  com.ifourthwall.dbm.user.dto.DeleteOrganizationDTO>
     * @Author: tanglei
     * @Date: 2019/1/3 15:39
     */
    BaseResponse<DeleteOrganizationDTO> deleteOrganization(DeleteOrganizationDTO deleteOrganizationDTO);
}
