package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWModule;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;

/**
 * @author tanglei
 */
public interface ModuleFacade {

    /**
     * 模块树
     * @Param: [queryTreeModuleReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <   com.ifourthwall.dbm.user.dto.QueryTreeModuleReqDTO>
     * @Author: tanglei
     * @Date: 2020/1/14 10:10
     */
    BaseResponse<List<QueryTreeModuleResDTO>> moduleTree(QueryTreeModuleReqDTO queryTreeModuleReqDTO);

    /**
     * 根据服务id查询指定的模块树
     * @Param: [moduleTreeReqDTO]
     * @Return: ocom.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.ModuleTreeResDTO>
     * @Author: tanglei
     * @Date: 2020/2/24 14:07
     */
    BaseResponse<ModuleTreeResDTO> moduleTreeByServiceId(ModuleTreeReqDTO moduleTreeReqDTO);

    /**
     * 根据角色ids去查询的模块的权限
     * @Param: [queryModulesByRoleIdsReqDTO]
     * @Return: ocom.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.common.base.IFWModule>
     * @Author: tanglei
     * @Date: 2020/3/23 14:07
     */
    BaseResponse<List<IFWModule>> queryModulesByRoleIds(QueryModulesByRoleIdsReqDTO queryModulesByRoleIdsReqDTO);


    /**
     * 通过roleIds查询指定的modules
     * @Param: [queryModulesByRoleIdsReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <java.util.List<com.ifourthwall.common.base.IFWModule>
     * @Author: tanglei
     * @Date: 2020/3/23 14:07
     */
    BaseResponse<List<IFWModule>> findModulesByRoleIds(QueryModulesByRoleIdsReqDTO queryModulesByRoleIdsReqDTO);

    /**
     * 后台根据服务id查询指定的模块树
     * @Param: [moduleTreeReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.ModuleTreeResDTO>
     * @Author: tanglei
     * @Date: 2020/2/24 14:07
     */
    BaseResponse<ModuleTreeResDTO> adminModuleTreeByServiceId(ModuleTreeReqDTO moduleTreeReqDTO);

    /**
     * 查询登陆的这个人有没有后台某个服务（接口）的权限
     * @Param: [queryAddressReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.QueryAddressResDTO>
     * @Author: tanglei
     * @Date: 2020/5/18 22:04
     */
    BaseResponse<QueryAddressResDTO> queryJurisdictionAddress(QueryAddressReqDTO queryAddressReqDTO);
}
