package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 17:06 2019/10/31
 * @Modified By:
 */
public interface DeptFacade {

    /**
     * 新增部门
     * @Param: [insertDeptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < com.ifourthwall.dbm.user.dto.InsertDeptDTO>
     * @Author: tanglei
     * @Date: 2019/1/4 16:41
     */
    BaseResponse<InsertDeptDTO> saveDept(InsertDeptDTO insertDeptDTO);


    /**
     * 修改部门名
     * @Param: [updateDeptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <com.ifourthwall.dbm.user.dto.UpdateDeptDTO>
     * @Author: tanglei
     * @Date: 2020/1/6 9:36
     */
    BaseResponse<UpdateDeptDTO> updateDept(UpdateDeptDTO updateDeptDTO);


    /**
     * 删除部门
     * @Param: [deleteDeptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.DeleteDeptDTO>
     * @Author: tanglei
     * @Date: 2020/1/6 10:16
     */
    BaseResponse<DeleteDeptDTO> deleteDept(DeleteDeptDTO deleteDeptDTO);

    /**
     * 部门列表
     * @Param: [queryTreeDeptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse < java.util.List <  com.ifourthwall.dbm.user.dto.QueryTreeDeptDTO>>
     * @Author: tanglei
     * @Date: 2020/1/4 13:57
     */
    BaseResponse<List<QueryTreeDeptDTO>> queryListDept(QueryTreeDeptDTO queryTreeDeptDTO);


    /**
     * 查询部门的信息
     * @Param: [ifwDeptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.IFWDeptDTO>>
     * @Author: tanglei
     * @Date: 2019/12/30 15:34
     */
    BaseResponse<IFWDeptDTO> findDeptDTOById(IFWDeptDTO ifwDeptDTO);


   /**
     * 通过岗位id查询部门
     * @Param: [deptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.DeptDTO>
     * @Author: daixingqiang
     * @Date: 2019/10/31 18:01
    */
    BaseResponse<List<DeptDTO>> queryListDeptByPositionIdS(DeptDTO deptDTO);


    /**
     * 通过多个部门ids查询部们名并拼接父级部门名
     * @Param: [deptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.DeptDTO>>
     * @Author: daixingqiang
     * @Date: 2019/12/5 15:34
     */
    BaseResponse<List<DeptDTO>> queryListDeptByDeptIds(DeptDTO deptDTO);

    /**
     * 部门的集合ids
     * @Param: tenantId
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<java.lang.String>>
     * @Author: tanglei
     * @Date: 2020/1/6 11:36
     */
    BaseResponse<List<String>> queryListDeptIds(String tenantId,String userId);

    /**
     * 根据部门id获取部门的信息
     * @Param: [getDeptDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.GetDeptDTO>
     * @Author: tanglei
     * @Date: 2020/1/4 13:57
     */
    BaseResponse<GetDeptDTO> getDeptById(GetDeptDTO getDeptDTO);

    /**
     * 查询所有部门
     * @Param: [queryDeptsReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse <java.util.List<com.ifourthwall.dbm.user.dto.QueryDeptsDTO>>
     * @Author: tanglei
     * @Date: 2020/2/21 13:57
     */
    BaseResponse<List<QueryDeptsDTO>> queryDepts(QueryDeptsReqDTO queryDeptsReqDTO);

    /**
     * 根据部门ids和租户id获取部门的信息
     * @Param: [queryDeptInfosReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List< com.ifourthwall.dbm.user.dto.QueryDeptInfosResDTO>>
     * @Author: tanglei
     * @Date: 2020/1/4 13:57
     */
    BaseResponse<List<QueryDeptResDTO>> getDeptInfosByDeptIds(QueryDeptReqDTO queryDeptInfosReqDTO);

    /**
     * 根据部门id查询包括部门和下面的子级
     * @Param: [querySubclassDeptReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.user.dto.QuerySubclassDeptResDTO>
     * @Author: tanglei
     * @Date: 2020/5/13 17:04
     */
    BaseResponse<List<QuerySubclassDeptResDTO>> queryDeptSubclass(QuerySubclassDeptReqDTO querySubclassDeptReqDTO);
}