package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Description:
 * @Date: Created in 16:46 2020/2/10
 * @Modified By:
 */
public interface CustomerFacade {

    /**
     * 客户列表的信息展示
     * @Param: [queryCustomerReqDTO]
     * @Return: org.springframework.http.ResponseEntity<com.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.dbm.user.dto.QueryCustomerResDTO>>>
     * @Author: tanglei
     * @Date: 2020/2/10 15:34
     */
    BaseResponse<List<QueryCustomerResDTO>> queryCustomerInfos(QueryCustomerReqDTO queryCustomerReqDTO);

    /**
     * 客户列表的分页展示和客户名称的搜索
     * @Param: [pageCustomerReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.PageCustomerResDTO>>>
     * @Author: tanglei
     * @Date: 2020/2/11 15:34
     */
    BaseResponse<PageCustomerResDTO> queryCustomerPageInfo(PageCustomerReqDTO pageCustomerReqDTO);

    /**
     * 控制客户对服务的启用或者停用
     * @Param: [deleteRoleIdUserBO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.DeleteTenantDTO>>>
     * @Author: tanglei
     * @Date: 2020/2/12 15:34
     */
    BaseResponse<DeleteTenantDTO> updateCustomerStatus(DeleteTenantDTO deleteTenantDTO);

    /**
     * 审核租户
     * @Param: [updateAuthenticationDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<   com.ifourthwall.dbm.user.dto.UpdateAuthenticationDTO>>>
     * @Author: tanglei
     * @Date: 2020/2/12 16:34
     */
    BaseResponse<UpdateAuthenticationDTO> updateAuthenticationCustomer(UpdateAuthenticationDTO updateAuthenticationDTO);

    /**
     * 服务列表的查询
     * @Param: [queryServiceReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.QueryServiceResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/13 14:34
     */
    BaseResponse<List<QueryServiceResDTO>> queryServiceInfos(QueryServiceReqDTO queryServiceReqDTO);

    /**
     * 服务的购买
     * @Param: [updateCustomerReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<   com.ifourthwall.dbm.user.dto.UpdateCustomerResDTO>
     * @Author: tanglei
     * @Date: 2020/2/14 14:34
     */
    BaseResponse<UpdateCustomerResDTO> customerPurchaseService(UpdateCustomerResDTO updateCustomerResDTO);

    /**
     * 客户消息信息的展示
     * @Param: [pageContactReqDTO]
     * @Return: org.springframework.http.ResponseEntity<com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.PageContactResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/10 15:34
     */
    BaseResponse<PageContactResDTO> queryContactInfos(PageContactReqDTO pageContactReqDTO);

    /**
     * 客户消息状态控制
     * @Param: [updateContactValidResDTO]
     * @Return: org.springframework.http.ResponseEntity<com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.UpdateContactValidResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/10 15:34
     */
    BaseResponse<UpdateContactValidResDTO> updateContactValid(UpdateContactValidResDTO updateContactValidResDTO);
}
