package com.ifourthwall.dbm.user.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.user.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-02-17 10:11
 * @Description:
 */
public interface AccountManagementFacade {

    /**
     * 账号管理条件分页查询
     * @Param: [queryCustomerReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.user.dto.PageAccountResDTO>
     * @Author: tanglei
     * @Date: 2020/2/10 15:34
     */
    BaseResponse<PageAccountResDTO> queryAccountPageInfo(PageAccountReqDTO pageAccountReqDTO);

    /**
     * 账号管理的启用和停用
     * @Param: [updateAccountStatusDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.UpdateAccountStatusDTO>>
     * @Author: tanglei
     * @Date: 2020/2/17 15:34
     */
    BaseResponse<UpdateAccountStatusDTO> updateAccountStatus(UpdateAccountStatusDTO updateAccountStatusDTO);

    /**
     * 查询所有后台角色的信息
     * @Param: [queryAccountRoleReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.QueryAcountRoleResDTO>
     * @Author: tanglei
     * @Date: 2020/2/17 15:34
     */
    BaseResponse<List<QueryAcountRoleResDTO>> queryRoles(QueryAccountRoleReqDTO queryAccountRoleReqDTO);

    /**
     * 修改账号管理信息
     * @Param: [updateAccountStatusDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.UpdateAccountManagementResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/18 10:19
     */
    BaseResponse<UpdateAccountManagementResDTO> updateAccountManagement(UpdateAccountManagementResDTO updateAccountStatusDTO);

    /**
     * 增加账号的信息
     * @Param: [insertAccountManagementResDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.user.dto.InsertAccountManagementResDTO>>
     * @Author: tanglei
     * @Date: 2020/2/18 10:19
     */
    BaseResponse<InsertAccountManagementResDTO> insertAccountManagement(InsertAccountManagementResDTO insertAccountManagementResDTO);
}
