package com.ifourthwall.dbm.user.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 18:33 2019/12/4
 * @Modified By:
 */
@Data
@ToString(callSuper = true)
public class UserInformationDTO implements Serializable {

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("登录名")
    private String loginName;

    @ApiModelProperty("真实名")
    private String employeeName;

    @ApiModelProperty("用户的头像")
    private String iconUrl;

    @ApiModelProperty("部门和岗位拼接名")
    private String deptPositionName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("部门名")
    private String deptName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("入职时间")
    private Date createTime;

    @ApiModelProperty("用户的密码")
    private String userPassword;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("岗位ids")
    private List<PositionIdsDTO> positionIds;

    @ApiModelProperty("角色ids")
    private List<RoleIdsDTO> roleIds;

    @ApiModelProperty("部门集合")
    private List<DeptNamesDTO> deptNames;


}
