package com.ifourthwall.dbm.user.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2019-12-30 11:07
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UserInfoDTO implements Serializable {


    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private String userId;
    /**
     * 登录名
     */
    @ApiModelProperty("登录名")
    private String loginName;
    /**
     * 电话号码
     */
    @ApiModelProperty("电话号码")
    private String phone;
    /**
     * 电邮
     */
    @ApiModelProperty("电邮")
    private String email;
    /**
     * 头像
     */
    @ApiModelProperty("头像")
    private String iconUrl;
    /**
     * 背景图片
     */
    @ApiModelProperty("背景图片")
    private String backgroundUrl;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 租户id
     */
    @ApiModelProperty("租户id")
    private String tenantId;
    /**
     * 组织id
     */
    @ApiModelProperty("组织id")
    private String organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String organizationName;


    @ApiModelProperty("组织状态")
    private String authenticationStatus;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;


}
