package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: hao.dai
 * @Date: 2019/10/10 15:24
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UserDTO extends BaseReqDTO {

    /**
     * 0 - 生效 1 - 未生效 2 - 删除
     */
    @ApiModelProperty("0 - 生效 1 - 未生效 2 - 删除")
    private String valid;

    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private String userId;

    /**
     * 登录名
     */
    @ApiModelProperty("登录名")
    private String loginName;

    /**
     * 密码
     */
    @ApiModelProperty("密码")
    private String userPassword;

    /**
     * 电话号码
     */
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty("电子邮箱")
    private String email;

    /**
     * 头像
     */
    @ApiModelProperty("头像")
    private String iconUrl;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 新密码
     */
    @ApiModelProperty("新密码")
    private String newPassword;

    /**
     * 租户id
     */
    @ApiModelProperty("租户id")
    private String tenantId;

    /**
     * 岗位表信息
     */
    @ApiModelProperty("岗位表信息")
    private List<PositionDTO> positionDTOS;

    /**
     * 部门表信息
     */
    @ApiModelProperty("部门表信息")
    private  List<DeptDTO> deptDTOS;
    /**
     * 雇员信息
     */
    @ApiModelProperty("雇员信息")
    private EmployeeDTO employeeDTO;
    /**
     * 角色信息
     */
    @ApiModelProperty("角色信息")
    private RoleDTO roleDTO;
    /**
     * token
     */
    @ApiModelProperty("token")
    private String token;

    /**
     * code
     */
    @ApiModelProperty("code")
    private String code;

    /**
     * 多个角色
     */
    @ApiModelProperty("多个角色")
    private List<RoleDTO> roleDTOS;

    /**
     * 多个module
     */
    @ApiModelProperty("多个module")
    private List<ModuleDTO> moduleDTOS;

    /**
     * userIds
     */
    @ApiModelProperty("userIds")
    private List<String> userIds;

    /**
     * 岗位名
     */
    @ApiModelProperty("岗位名")
    private String positionName;

    /**
     * 部门名
     */
    @ApiModelProperty("部门名")
    private String deptName;

    /**
     * 岗位id
     */
    @ApiModelProperty("岗位id")
    private String positionId;

    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private String deptId;

    /**
     * 岗位对应部门id
     */
    @ApiModelProperty("岗位对应部门id")
    private List<Map<String,String>> deptPositionIds;

    /**
     * 真实姓名
     */
    @ApiModelProperty("员工星密")
    private String employeeName;

    /**
     * 真实姓名
     */
    @ApiModelProperty("真实姓名")
    private String roleName;

}
