package com.ifourthwall.dbm.user.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tanglei
 */
@Data
@ToString(callSuper = true)
public class ServiceDTO implements Serializable {

    @ApiModelProperty("服务的流水号id")
    private Long id;

    @ApiModelProperty("服务id")
    private java.lang.String serviceId;

    @ApiModelProperty("服务名字")
    private java.lang.String serviceName;

    @ApiModelProperty("服务描述")
    private java.lang.String serviceDescription;

    @ApiModelProperty("服务图标")
    private java.lang.String serviceIconUrl;

    @ApiModelProperty("服务状态")
    private java.lang.String serviceStatus;

    @ApiModelProperty("服务的开始时间")
    private Date serviceStartsDate;

    @ApiModelProperty("服务的结束时间")
    private Date serviceEndDate;

    @ApiModelProperty("服务最大购买数量")
    private Integer maxServiceUserCount;

    @ApiModelProperty("服务创建人")
    private java.lang.String createBy;

    @ApiModelProperty("1 代购已购买")
    private String alreadyPurchased;

    @ApiModelProperty("服务的创建时间")
    private Date createTime;

    @ApiModelProperty("服务的修改人")
    private String updateBy;

    @ApiModelProperty("服务的修改时间")
    private Date updateTime;


    @ApiModelProperty("租户名称")
    private String tenantName;
}
