package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;


@Data
@ToString(callSuper = true)
public class RegisterEmailDTO  extends BaseReqDTO {

    /**
     * 电邮
     */
    @ApiModelProperty("电邮")
    @Email
    private String email;

    /**
     * code
     */
    @NotNull
    @ApiModelProperty("code")
    private String code;

    /**
     * 登录名
     */
    @ApiModelProperty("登录名")
    private String loginName;

    /**
     * 密码
     */
    @ApiModelProperty("密码")
    private String userPassword;


}
