package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: tanglei
 * @Date: 2020-01-20 16:36
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryAuthenticationUserResDTO extends BaseReqDTO {

    @ApiModelProperty("租户名称")
    private String tenantName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("电子邮箱")
    private String email;

    @ApiModelProperty("密码")
    private String userPassword;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("用户id")
    private String userId;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String authenticationCompanyName;

    /**
     * 统一社会信用代码
     */
    @ApiModelProperty("统一社会信用代码")
    private String authenticationCompanyCode;

    /**
     * 营业执照
     */
    @ApiModelProperty("营业执照")
    private String authenticationLicenseUrl;

    /**
     * 公司logo
     */
    @ApiModelProperty("公司logo")
    private String authenticationLogoUrl;

    /**
     * 公司类型
     */
    @ApiModelProperty("公司类型")
    private String authenticationCompanyType;

    /**
     * 公司规模
     */
    @ApiModelProperty("公司规模")
    private String authenticationCompanyScale;

    /**
     * 公司地址
     */
    @ApiModelProperty("公司地址")
    private String authenticationCompanyAddress;

    /**
     * 公司详细地址
     */
    @ApiModelProperty("公司详细地址")
    private String authenticationCompanyDetailAddress;


}
