package com.ifourthwall.dbm.user.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

/**
 * @Author: tanglei
 * @Date: 2020-01-02 10:40
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DeptUserInfoDTO extends BaseReqDTO {


    /**
     * 用户的id
     */
    @ApiModelProperty("用户的id")
    private String userId;

    /**
     * 电话号码
     */
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 用户的头像
     */
    @ApiModelProperty("用户的头像")
    private String iconUrl;

    /**
     * 真实姓名
     */
    @ApiModelProperty("真实姓名")
    private String realName;

    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private String deptId;

    /**
     * 父级部门的id
     */
    @ApiModelProperty("父级部门的id")
    private String parentDeptId;

    /**
     * 部门名称
     */
    @ApiModelProperty("部门名称")
    private String deptName;

    /**
     * 岗位id
     */
    @ApiModelProperty("岗位id")
    private String positionId;

    /**
     * 岗位名称
     */
    @ApiModelProperty("岗位名称")
    private String positionName;

    /**
     * 部门的详细信息
     */
    @ApiModelProperty("部门的详细信息")
    private String deptDetailName;

    /**
     * 部门+岗位的信息
     */
    @ApiModelProperty("部门+岗位的信息")
    private String deptPositionName;





}