package com.ifourthwall.dbm.user.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: daixingqiang
 * @Description:
 * @Date: Created in 11:52 2019/10/29
 * @Modified By:
 */
@Data
@ToString(callSuper = true)
public class DeptDTO implements Serializable {

    /**
    * 部门id
     */
    @ApiModelProperty("部门id")
    private String deptId;

    /**
    * 部门名称
     */
    @ApiModelProperty("部门名称")
    private String deptName;

    /**
    * 部门所处层级
     */
    @ApiModelProperty("部门所处层级")
    private Integer deptLevel;

    /**
    * 父级部门id
     */
    @ApiModelProperty("父级部门id")
    private String parentDeptId;

    /**
    * 部门负责人
     */
    @ApiModelProperty("部门负责人")
    private String deptLeader;


    /**
     * 岗位信息
     */
    @ApiModelProperty("岗位信息")
    private List<PositionDTO> positionDTO;

    /**
     * 岗位ids
     */
    @ApiModelProperty("岗位ids")
    private List<String> positionIds;

}