package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.provider.dto.employee.*;

/**
 * @Author: YangPeng
 * @Date: 2020/9/24 09:51
 * @Description:
 */
public interface MerchantEmployeeFacade {

    /**
     * 新增商户人员
     *
     * @param insertEmployee
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/23 18:22
     */
    BaseResponse insertMerchantEmployee(InsertMerchantEmployeeDTO insertEmployee);

    /**
     * 修改商户人员
     * @Author: YangPeng
     * @Date: 2020/9/25 18:20
     * @param upEmployee
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateMerchantEmployee(UpdateMerchantEmployeeDTO upEmployee);

    /**
     * 查询商户人员列表
     * @Author: YangPeng
     * @Date: 2020/10/9 11:57
     * @param queryPage
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.employee.QueryMerchantEmployeePageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryMerchantEmployeePageDTO>> queryMerchantEmployeePage(QueryMerchantEmployeePageQuDTO queryPage);

    /**
     * 查询商户人员详情
     * @Author: YangPeng
     * @Date: 2020/10/9 15:16
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.employee.QueryMerchantEmployeeInfoDTO>
     * @throws
     */
    BaseResponse<QueryMerchantEmployeeInfoDTO> queryMerchantEmployeeInfo(QueryMerchantEmployeeInfoQuDTO queryInfo);

    /**
     * 商户人员离职
     * @Author: YangPeng
     * @Date: 2020/10/9 16:19
     * @param resign
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse merchantEmployeeResign(MerchantEmployeeResignDTO resign);

    /**
     * 删除商户人员
     * @Author: YangPeng
     * @Date: 2020/10/9 16:30
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteMerchantEmployee(DeleteMerchantEmployeeDTO delete);
}
