package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.provider.dto.AllTranslationDTO;
import com.ifourthwall.dbm.provider.dto.ListTranslationDTO;
import com.ifourthwall.dbm.provider.dto.TranslationDTO;
import com.ifourthwall.dbm.provider.dto.merchant.*;

import java.util.Map;

/**
 * @Author: YangPeng
 * @Date: 2020/9/2 15:48
 * @Description:
 */
public interface EstateMerchantFacade {

    /**
     * 新增商户
     * @Author: YangPeng
     * @Date: 2020/9/2 16:39
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<InsertMerchantReDTO> insertMerchant(InsertMerchantDTO insert);

    /**
     * 修改商户
     *
     * @param upMerchant
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/7 14:06
     */
    BaseResponse updateMerchant(UpdateMerchantDTO upMerchant);

    /**
     * 查询商户详情
     *
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.merchant.QueryMerchantInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/9/7 14:06
     */
    BaseResponse<QueryMerchantInfoDTO> queryMerchantInfo(QueryMerchantInfoQuDTO queryInfo);

    /**
     * 查询商户列表
     * @Author: YangPeng
     * @Date: 2020/9/8 14:55
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.provider.dto.merchant.QueryMerchantPageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryMerchantPageDTO>> queryMerchantPage(QueryMerchantPageQuDTO query);

    /**
     * 翻译字典列表
     * @Author: YangPeng
     * @Date: 2020/9/9 16:59
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<java.util.Map<java.lang.String,java.lang.String>>
     * @throws
     */
    BaseResponse<AllTranslationDTO> allTranslation(TranslationDTO queryInfo);

    /**
     * 商户退租
     * @Author: YangPeng
     * @Date: 2020/9/14 14:06
     * @param surrender
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse merchantSurrender(MerchantSurrenderDTO surrender);

    /**
     * 新增商户附件
     * @Author: YangPeng
     * @Date: 2020/11/3 17:51
     * @param upInsertMerchantAnnex
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertMerchantAnnex(InsertMerchantAnnexDTO upInsertMerchantAnnex);

    /**
     * 修改商户附件
     * @Author: YangPeng
     * @Date: 2020/11/3 17:59
     * @param upMerchant
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateMerchantAnnex(UpdateMerchantAnnexDTO upMerchant);

    /**
     * 查询商户附件
     * @Author: YangPeng
     * @Date: 2020/11/3 18:05
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.merchant.QueryMerchantAnnexDTO>
     * @throws
     */
    BaseResponse<QueryMerchantAnnexDTO> queryMerchantAnnex(QueryMerchantAnnexQuDTO queryInfo);

    /**
     * 翻译字典列表（list）
     * @Author: YangPeng
     * @Date: 2020/12/15 15:09
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.ListTranslationDTO>
     * @throws
     */
    BaseResponse<ListTranslationDTO> listTranslation(TranslationDTO queryInfo);

    /**
     * 查询商户详情（基础）
     * @Author: YangPeng
     * @Date: 2020/12/21 14:31
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.merchant.QueryMerchantBasisInfoDTO>
     * @throws
     */
    BaseResponse<QueryMerchantBasisInfoDTO> queryMerchantBasisInfo(QueryMerchantBasisInfoQuDTO query);
}
