package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.provider.dto.enclosure.EnclosureDTO;
import com.ifourthwall.dbm.provider.dto.enclosure.EstateAnnexDTO;
import com.ifourthwall.dbm.provider.dto.estate.*;
import com.ifourthwall.dbm.provider.dto.merchant.MerchantSpaceInfo;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/17 09:54
 * @Description:
 */
public interface EstateFacade {

    /**
     * 根据estateId查询estate名称
     * @Author: YangPeng
     * @Date: 2020/11/17 9:54
     * @param queryList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.provider.dto.estate.QueryEstateListDTO>>
     * @throws
     */
    BaseResponse<List<QueryEstateListDTO>> queryEstateList(QueryEstateListQuDTO queryList);

    /**
     * provider首页
     * @Author: YangPeng
     * @Date: 2020/11/25 9:53
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.estate.QueryProviderHomeDTO>
     * @throws
     */
    BaseResponse<QueryProviderHomeDTO> queryProviderHome(QueryProviderHomeQuDTO queryInfo);

    /**
     * provider-我的
     * @param queryInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.estate.QueryProviderMineInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/11/25 15:30
     */
    BaseResponse<QueryProviderMineInfoDTO> queryProviderMineInfo(QueryProviderMineInfoQuDTO queryInfo);

    /**
     *provider-商住户列表
     * @Author: YangPeng
     * @Date: 2020/11/26 9:58
     * @param queryList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.provider.dto.estate.QueryProviderEstateListDTO>>
     * @throws
     */
    BaseResponse<List<QueryProviderEstateListDTO>> queryProviderEstateList(QueryProviderEstateListQuDTO queryList);

    /**
     * provider-商住户附件
     * @Author: YangPeng
     * @Date: 2020/12/3 14:10
     * @param estateAnnexDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.provider.dto.enclosure.EnclosureDTO>>
     * @throws
     */
    BaseResponse<List<EnclosureDTO>> estateAnnex(EstateAnnexDTO estateAnnexDTO);

    /**
     * 查询空间信息
     * @Author: YangPeng
     * @Date: 2021/1/6 17:10
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.provider.dto.merchant.MerchantSpaceInfo>>
     * @throws
     */
    BaseResponse<List<MerchantSpaceInfo>> queryWxEstateSpaceInfo(queryWxEstateSpaceInfoQuDTO query);
}
