package com.ifourthwall.dbm.provider.dto.residence;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/11 14:01
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryResidencePageDTO extends PageCommonExTDTO {

    @ApiModelProperty("名称搜索")
    private String nameLike;

    @ApiModelProperty("手机搜索")
    private String phoneLike;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("住户状态 (1.未入住 2.已入住 3.装修中 4.出租中 5.出售中 6.其他)")
    private String residenceStatusId;

    @ApiModelProperty("开始时间")
    private Date beginTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("默认逆序 1.倒叙")
    private Integer orderBy;

    @ApiModelProperty("空间搜索")
    private List<String> spaceIds;
}
