package com.ifourthwall.dbm.provider.dto.residence;

import com.ifourthwall.dbm.provider.dto.merchant.MerchantSpaceInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/14 11:17
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryResidenceBasisInfoDTO implements Serializable {

    @ApiModelProperty("住户状态 (1.未入住 2.已入住 3.装修中 4.出租中 5.出售中 6.其他)")
    private String residenceStatusId;

    @ApiModelProperty("住户状态 (1.未入住 2.已入住 3.装修中 4.出租中 5.出售中 6.其他)")
    private String residenceStatusName;

    @ApiModelProperty("住户业主名称")
    private String residenceOwnerName;

    @ApiModelProperty("业主身份证")
    private String residenceOwnerIdCard;

    @ApiModelProperty("业主手机号")
    private String residenceOwnerPhone;

    @ApiModelProperty("小程序背景图")
    private String backgroundPic;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("住户id")
    private String residenceId;

    @ApiModelProperty("住户人员id")
    private String residenceMemberId;

    @ApiModelProperty("有效期限")
    private Date contractBegin;

    @ApiModelProperty("入住时间")
    private Date contractEnd;

    @ApiModelProperty("总面积")
    private BigDecimal totalArea;

    @ApiModelProperty("空间id")
    private List<MerchantSpaceInfo> spaceInfo;
}
