package com.ifourthwall.dbm.provider.dto.residence;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.AnnexDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/10 14:33
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryResidenceAnnexQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

    @ApiModelProperty("住户id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_ID_NOT_NULL)
    private String residenceId;


}
