package com.ifourthwall.dbm.provider.dto.merchant;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.AnnexDTO;
import com.ifourthwall.dbm.provider.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/2 16:03
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryMerchantPageQuDTO extends PageCommonExTDTO {

    @ApiModelProperty("名称搜索")
    private String nameLike;

    @ApiModelProperty("手机搜索")
    private String phoneLike;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("商户状态（1.营业中 2.停业 3.退租  4.未入场 5.装修中 6.转租中 7.出租中 8.出售中 9.其他）")
    private String merchantStatusId;

    @ApiModelProperty("商户经营类型（1.餐饮 2.教育 3.服饰 4.娱乐 5.服务 6.体育用品 7.文具用品 8.其他）")
    private String merchantBusinessTypeId;

    @ApiModelProperty("开始时间")
    private Date beginTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("默认逆序 1.倒叙")
    private Integer orderBy;

    @ApiModelProperty("空间搜索")
    private List<String> spaceIds;

}
