package com.ifourthwall.dbm.provider.dto.merchant;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/2 16:03
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryMerchantPageDTO implements Serializable {

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("商户id")
    private String merchantId;

    @ApiModelProperty("商户经营类型（1.餐饮 2.教育 3.服饰 4.娱乐 5.服务 6.体育用品 7.文具用品 8.其他）")
    private String merchantBusinessTypeId;

    @ApiModelProperty("商户经营类型（1.餐饮 2.教育 3.服饰 4.娱乐 5.服务 6.体育用品 7.文具用品 8.其他）")
    private String merchantBusinessTypeName;

    @ApiModelProperty("商户规模")
    private String merchantScale;

    @ApiModelProperty("营业执照")
    private String businessLicensePic;

    @ApiModelProperty("商户性质（1.企业  2.个人）")
    private String merchantCharacterTypeId;

    @ApiModelProperty("商户性质（1.企业  2.个人）")
    private String merchantCharacterTypeName;

    @ApiModelProperty("商户状态（1.营业中 2.停业 3.退租  4.未入场 5.装修中 6.转租中 7.出租中 8.出售中 9.其他）")
    private String merchantStatusId;

    @ApiModelProperty("商户状态（1.营业中 2.停业 3.退租  4.未入场 5.装修中 6.转租中 7.出租中 8.出售中 9.其他）")
    private String merchantStatusName;

    @ApiModelProperty("负责人名称")
    private String merchantChargeName;

    @ApiModelProperty("负责人联系方式")
    private String merchantChargePhone;

    @ApiModelProperty("负责人身份证")
    private String merchantChargeIdCard;

    @ApiModelProperty("有效期限")
    private Date contractBegin;

    @ApiModelProperty("入住时间")
    private Date contractEnd;

    @ApiModelProperty("小程序背景图")
    private String backgroundPic;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者user_id")
    private String updateBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("空间id")
    private List<MerchantSpaceInfo> spaceInfo;

    @ApiModelProperty("商户人员id")
    private String merchantEmployeeId;

}
